package com.els.base.utils.json;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

/**
 * 把整型转化为布尔值的序列化，1为true， 不为1 则false
 * @author hzy
 *
 */
public class IntegerToBooleanSerializer extends JsonSerializer<Integer> {

	@Override
	public void serialize(Integer value, JsonGenerator gen, SerializerProvider serializers)
			throws IOException, JsonProcessingException {
		
		Integer yes = 1;
		if (yes.equals(value)) {
			gen.writeBoolean(true);
			
		}else{
			gen.writeBoolean(false);
		}
	}

}
