package com.els.base.utils.json;

import java.io.IOException;

import com.els.base.utils.SpringContextHolder;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonParser.Feature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public class JsonUtils {
	
	private static final String lock = "lock";
	private static ObjectMapper objectMapper = null;
	
	public static ObjectMapper getObjectMapper(){
		if (objectMapper != null) {
			return objectMapper;
		}
		synchronized (lock) {
			if (objectMapper != null) {
				return objectMapper;
			}
			objectMapper = (ObjectMapper) (SpringContextHolder.getOneBean(ObjectMapper.class) == null ? new ObjectMapper() : SpringContextHolder.getOneBean(ObjectMapper.class));
		}
		return objectMapper;
	}
	
	
	/**
	 * 把对象转化为json字符串
	 * @param object
	 * @return
	 * @throws JsonProcessingException
	 */
	public static String writeValueAsString(Object object) throws JsonProcessingException{
		return getObjectMapper().writeValueAsString(object);
	}
	
	/**
	 * 将json字符串转化为对象
	 * @param fromValue
	 * @param toValueType
	 * @return
	 * @throws JsonParseException
	 * @throws JsonMappingException
	 * @throws IOException
	 */
	public static <T> T convertValue(String fromValue, Class<T> toValueType) throws JsonParseException, JsonMappingException, IOException{
		getObjectMapper().configure(Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
		return getObjectMapper().readValue(fromValue, toValueType);
	}
	
	/**
	 * 将json字符串转化为 列表(Collection)
	 * @param fromValue
	 * @param toValueType
	 * @return
	 * @throws JsonParseException
	 * @throws JsonMappingException
	 * @throws IOException
	 */

	public static <T> T convertCollection(String fromValue, Class<T> collectionClass, Class<?> subCollectionClass, Class<?>... elementClasses) throws JsonParseException, JsonMappingException, IOException{
		JavaType javaType = getObjectMapper().getTypeFactory().constructParametrizedType(collectionClass, subCollectionClass, elementClasses);
		return getObjectMapper().readValue(fromValue, javaType);
	}
	
	public static JavaType getCollectionType(Class<?> collectionClass, Class<?> subCollectionClass, Class<?>... elementClasses){
		return getObjectMapper().getTypeFactory().constructParametrizedType(collectionClass, subCollectionClass, elementClasses);
	}

}
