package com.els.base.utils.txtImport;

import org.apache.commons.lang.StringUtils;

/**
 * @author linyuqin
 */
public class DoubleConverter implements StringToObjectConverter<Double> {
    @Override
    public Double convert(String content) throws Exception {
        if (StringUtils.isEmpty(content)) {
            return 0D;
        }
        Double num = null;
        try {
            num = Double.parseDouble(content);
        } catch (NumberFormatException e) {
            throw new NumberFormatException("'"+content+"'" +"无法转为数字!");
        }
        return num;
    }
}
