/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.uuid;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public class UUIDGenerator {
    public static final String PARAMETER_OBJECT_KEY = "_parameter";

    public static String generateUUID() {
        StringBuffer uuid = new StringBuffer();
        uuid.append(DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        uuid.append('-');
        uuid.append(UUID.randomUUID().toString().replaceAll("-", ""));
        return uuid.substring(0, 32);
    }

    public static String generateUUIDAndSetId(HashMap<String, Object> mybatisSqlContextMap) {
        return UUIDGenerator.generateUUIDAndSetId(mybatisSqlContextMap, "id");
    }

    public static String generateUUIDAndSetId(HashMap<String, Object> mybatisSqlContextMap, String propertyName) {
        String uuid = UUIDGenerator.generateUUID();
        try {
            Object id;
            Object object = mybatisSqlContextMap.get(PARAMETER_OBJECT_KEY);
            String nameOfGetMethod = "get" + StringUtils.capitalize((String)propertyName);
            Method getIdMethod = object.getClass().getMethod(nameOfGetMethod, new Class[0]);
            if (getIdMethod != null && (id = getIdMethod.invoke(object, new Object[0])) != null && id instanceof String && StringUtils.isNotBlank((String)((String)id))) {
                return (String)id;
            }
            String nameOfSetMethod = "set" + StringUtils.capitalize((String)propertyName);
            Method setIdMethod = object.getClass().getMethod(nameOfSetMethod, String.class);
            if (setIdMethod != null) {
                setIdMethod.invoke(object, uuid);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return uuid;
    }
}

