/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.image;

import com.els.base.utils.qrcode.QrcodeUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static BufferedImage cropImage(InputStream inputStream, int x, int y, int desWidth, int desHeight) throws IOException {
        BufferedImage bImage = ImageIO.read(inputStream);
        int srcWidth = bImage.getWidth();
        int srcHeight = bImage.getHeight();
        if (desWidth > srcWidth || desHeight > srcHeight) {
            throw new IllegalArgumentException("\u88c1\u526a\u7684\u957f\u5bbd\uff0c\u8d85\u51fa\u8303\u56f4");
        }
        BufferedImage desImage = bImage.getSubimage(x, y, desWidth, desHeight);
        return desImage;
    }

    public static BufferedImage contactVertical(File imageUp, File imageBelow) throws IOException {
        return ImageUtils.contactVertical(ImageIO.read(imageUp), ImageIO.read(imageBelow));
    }

    public static BufferedImage contactVertical(BufferedImage imageUp, BufferedImage imageBelow) throws IOException {
        int upWidth = imageUp.getWidth();
        int upHeight = imageUp.getHeight();
        int belowWidth = imageBelow.getWidth();
        int belowHeight = imageBelow.getHeight();
        int newWidth = upWidth > belowWidth ? upWidth : belowWidth;
        int newHeigth = upHeight + belowHeight;
        if (upWidth != belowWidth) {
            int blankLeftWidth = Math.abs(upWidth - belowWidth) / 2;
            int blankHeight = upWidth > belowWidth ? belowHeight : upHeight;
            BufferedImage blankLeftImage = ImageUtils.createRectlang(blankLeftWidth, blankHeight);
            int blankRightWidth = Math.abs(upWidth - belowWidth) - blankLeftWidth;
            BufferedImage blankRightImage = ImageUtils.createRectlang(blankRightWidth, blankHeight);
            if (upWidth > belowWidth) {
                imageBelow = ImageUtils.contactHorizontal(blankLeftImage, imageBelow);
                imageBelow = ImageUtils.contactHorizontal(imageBelow, blankRightImage);
            } else {
                imageUp = ImageUtils.contactHorizontal(blankLeftImage, imageUp);
                imageUp = ImageUtils.contactHorizontal(imageUp, blankRightImage);
            }
        }
        BufferedImage imageNew = new BufferedImage(newWidth, newHeigth, 1);
        int[] upImageByte = imageUp.getRGB(0, 0, newWidth, upHeight, new int[newWidth * upHeight], 0, newWidth);
        imageNew.setRGB(0, 0, newWidth, upHeight, upImageByte, 0, newWidth);
        int[] belowImageByte = imageBelow.getRGB(0, 0, newWidth, belowHeight, new int[newWidth * belowHeight], 0, newWidth);
        imageNew.setRGB(0, upHeight, newWidth, belowHeight, belowImageByte, 0, newWidth);
        return imageNew;
    }

    public static BufferedImage contactCenter(BufferedImage outter, BufferedImage inner, int paddingTop, int paddingLeft) {
        if (paddingTop < 0 || paddingLeft < 0) {
            throw new IllegalArgumentException("\u5185\u8fb9\u8ddd\u4e0d\u80fd\u5c11\u4e8e0");
        }
        int outWidth = outter.getWidth();
        int outHeight = outter.getHeight();
        int inWidth = inner.getWidth();
        int inHeight = inner.getHeight();
        if (inWidth > outWidth) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u5408\u5e76\uff0c\u56e0\u4e3a\u5185\u56fe\u7247\u5bbd\u5ea6\u5927\u4e8e\u5916\u56fe\u7247");
        }
        if (paddingTop + inHeight > outHeight) {
            throw new IllegalArgumentException("\u4e0a\u5185\u8fb9\u8ddd\u8fc7\u5927");
        }
        if (inWidth + paddingLeft > outWidth) {
            throw new IllegalArgumentException("\u5de6\u5185\u8fb9\u8ddd\u8fc7\u5927");
        }
        int[] inImageByte = inner.getRGB(0, 0, inWidth, inHeight, new int[inWidth * inHeight], 0, inWidth);
        outter.setRGB(paddingLeft, paddingTop, inWidth, inHeight, inImageByte, 0, inWidth);
        return outter;
    }

    public static BufferedImage contactHorizontal(File imageLeft, File imageRight) throws IOException {
        return ImageUtils.contactHorizontal(ImageIO.read(imageLeft), ImageIO.read(imageRight));
    }

    public static BufferedImage contactHorizontal(BufferedImage imageLeft, BufferedImage imageRight) throws IOException {
        int newHeigth;
        int leftWidth = imageLeft.getWidth();
        int leftHeight = imageLeft.getHeight();
        int rightWidth = imageRight.getWidth();
        int rightHeigth = imageRight.getHeight();
        int newWidth = leftWidth + rightWidth;
        int n = newHeigth = leftHeight > rightHeigth ? leftHeight : rightHeigth;
        if (leftHeight != rightHeigth) {
            int blankHeight = Math.abs(leftHeight - rightHeigth);
            int blankWidth = leftHeight > rightHeigth ? rightWidth : leftWidth;
            BufferedImage blankImage = ImageUtils.createRectlang(blankWidth, blankHeight);
            if (leftHeight > rightHeigth) {
                imageRight = ImageUtils.contactVertical(imageRight, blankImage);
            } else {
                imageLeft = ImageUtils.contactVertical(imageLeft, blankImage);
            }
        }
        BufferedImage imageNew = new BufferedImage(newWidth, newHeigth, 1);
        int[] leftImageByte = imageLeft.getRGB(0, 0, leftWidth, newHeigth, new int[leftWidth * newHeigth], 0, leftWidth);
        imageNew.setRGB(0, 0, leftWidth, newHeigth, leftImageByte, 0, leftWidth);
        int[] rightImageByte = imageRight.getRGB(0, 0, rightWidth, newHeigth, new int[rightWidth * newHeigth], 0, rightWidth);
        imageNew.setRGB(leftWidth, 0, rightWidth, newHeigth, rightImageByte, 0, rightWidth);
        return imageNew;
    }

    public static BufferedImage createRectlang(int width, int height) {
        BufferedImage rectlangImage = new BufferedImage(width, height, 1);
        Graphics2D rightG = rectlangImage.createGraphics();
        rightG.setColor(Color.WHITE);
        rightG.fillRect(0, 0, width, height);
        rightG.dispose();
        return rectlangImage;
    }

    public static void main(String[] args) throws IOException {
        File image1 = new File("G:\\doc\\wt\\wt\\\u80f6\u539f\u86cb\u767d\u7ef4\u751f\u7d20C\u7ef4\u751f\u7d20E\u7c89-\u7ade\u54c1\u5bf9\u6bd4.jpg");
        BufferedImage imageUp = ImageIO.read(image1);
        BufferedImage imageBelow = QrcodeUtils.writeQrcode("www.baidu.com", "utf-8", 250);
        BufferedImage imageNew = ImageUtils.contactCenter(imageUp, imageBelow, 80, 23);
        File outFile = new File("G:\\doc\\wt\\wt\\test.jpg");
        ImageIO.write((RenderedImage)imageNew, "jpg", outFile);
    }
}

