package com.els.base.utils.txtImport;

import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import jxl.Cell;
import jxl.Sheet;
import org.apache.commons.lang.StringUtils;

import java.util.List;

/**
 * @author linyuqin
 */
public class LongConverter implements StringToObjectConverter<Long> {

    @Override
    public Long convert(String content) throws Exception {
        if (StringUtils.isEmpty(content)) {
            return 0L;
        }
        Long num = null;
        try {
            num = Long.parseLong(content);
        } catch (NumberFormatException e) {
            throw new NumberFormatException("'"+content+"'" +"无法转为数字!");
        }
        return num;
    }
}
