/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.excel;

import com.els.base.utils.excel.BigDecimalConverter;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.IntegerConverter;
import com.els.base.utils.excel.LongConverter;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;

public class ConverterFactory {
    private final Map<String, StrToObjConverter> toObjMap = new Hashtable<String, StrToObjConverter>();
    private final Map<String, ObjToStrConverter> toStrMap = new Hashtable<String, ObjToStrConverter>();
    private static ConverterFactory factory = new ConverterFactory();

    private void registe() {
        this.toObjMap.put(Integer.class.toString(), new IntegerConverter());
        this.toObjMap.put(BigDecimal.class.toString(), new BigDecimalConverter());
        this.toObjMap.put(Date.class.toString(), new DateConverter());
        this.toObjMap.put(Long.class.toString(), new LongConverter());
        this.toStrMap.put(Integer.class.toString(), new IntegerConverter());
        this.toStrMap.put(BigDecimal.class.toString(), new BigDecimalConverter());
        this.toStrMap.put(Date.class.toString(), new DateConverter());
        this.toStrMap.put(Long.class.toString(), new LongConverter());
    }

    public static StrToObjConverter getDefaultToObjConverter(Class clazz) {
        return factory.getToObjMap().get(clazz.toString());
    }

    public static ObjToStrConverter getDefaultToStrConverter(Class clazz) {
        return factory.getToStrMap().get(clazz.toString());
    }

    private ConverterFactory() {
        this.registe();
    }

    public Map<String, StrToObjConverter> getToObjMap() {
        return this.toObjMap;
    }

    public Map<String, ObjToStrConverter> getToStrMap() {
        return this.toStrMap;
    }
}

