/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.qrcode.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.service.AccountConfigService;
import com.els.base.wechat.account.utils.WxAccountConfigUtils;
import com.els.base.wechat.common.WxMpServiceUtils;
import com.els.base.wechat.msg.entity.WxMsgRule;
import com.els.base.wechat.msg.service.WxMsgRuleService;
import com.els.base.wechat.qrcode.dao.WxQrcodeMapper;
import com.els.base.wechat.qrcode.entity.WxQrcode;
import com.els.base.wechat.qrcode.entity.WxQrcodeExample;
import com.els.base.wechat.qrcode.service.WxQrcodeService;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpQrCodeTicket;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="wxQrcodeService")
public class WxQrcodeServiceImpl
implements WxQrcodeService {
    @Autowired
    protected WxQrcodeMapper wxQrcodeMapper;
    @Autowired
    protected AccountConfigService accountConfigService;
    @Autowired
    protected WxMsgRuleService wxMsgRuleService;

    @CacheEvict(value={"wxQrcode"}, allEntries=true)
    public void addObj(WxQrcode t) {
        this.wxQrcodeMapper.insertSelective(t);
    }

    @CacheEvict(value={"wxQrcode"}, allEntries=true)
    public void deleteObjById(String id) {
        this.wxQrcodeMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"wxQrcode"}, allEntries=true)
    public void modifyObj(WxQrcode t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        this.wxQrcodeMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"wxQrcode"}, key="'WxQrcodeService_' + #root.methodName + '_' +#id")
    public WxQrcode queryObjById(String id) {
        return this.wxQrcodeMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"wxQrcode"}, key="'WxQrcodeService_' + #root.methodName + '_'+ #example.toJson()")
    public List<WxQrcode> queryAllObjByExample(WxQrcodeExample example) {
        return this.wxQrcodeMapper.selectByExample(example);
    }

    @Cacheable(value={"wxQrcode"}, key="'WxQrcodeService_' + #root.methodName + '_'+ #example.toJson()")
    public PageView<WxQrcode> queryObjByPage(WxQrcodeExample example) {
        PageView pageView = example.getPageView();
        if (pageView == null) {
            pageView = new PageView(1, 10);
            example.setPageView((PageView<WxQrcode>)pageView);
        }
        pageView.setQueryResult(this.wxQrcodeMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"wxQrcode"}, allEntries=true)
    @Transactional
    public WxQrcode createLimitQrcode(WxQrcode wxQrcode) throws WxErrorException, IOException {
        if (new Date().getTime() > wxQrcode.getValidTime().getTime() - (long)WxQrcode.QRCODE_MAX_EXPIRED_SECOND.intValue()) {
            throw new CommonException("\u6709\u6548\u65f6\u95f4\u8d85\u51fa\u6700\u5927\u65f6\u957f");
        }
        int expiredSeconds = (int)(wxQrcode.getValidTime().getTime() - new Date().getTime());
        AccountConfig account = WxAccountConfigUtils.getByOrginId(wxQrcode.getAccountOriginId());
        WxMpService wxMpService = WxMpServiceUtils.getWxMpServiceByAccount(account);
        WxMpQrCodeTicket ticket = wxMpService.getQrcodeService().qrCodeCreateTmpTicket(Integer.valueOf(wxQrcode.getSceneStr()).intValue(), Integer.valueOf(expiredSeconds));
        File qrcodePicture = wxMpService.getQrcodeService().qrCodePicture(ticket);
        FileData attachment = new FileData();
        attachment.setFileName("wxQrcode.jpg");
        attachment.setFileSuffix("jpg");
        FileManagerFactory.getFileManager().write(qrcodePicture, attachment);
        if (StringUtils.isBlank((String)wxQrcode.getName())) {
            wxQrcode.setName("qrcode" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        }
        wxQrcode.setType(WxQrcode.QRCODE_TYPE_LIMIT);
        wxQrcode.setImgUrl(attachment.getFileUrl());
        wxQrcode.setTicket(ticket.getTicket());
        wxQrcode.setContent(ticket.getUrl());
        this.addObj(wxQrcode);
        return wxQrcode;
    }

    @Override
    @CacheEvict(value={"wxQrcode"}, allEntries=true)
    @Transactional
    public WxQrcode createUnLimitQrcode(WxQrcode wxQrcode) throws WxErrorException, IOException {
        AccountConfig account = WxAccountConfigUtils.getByOrginId(wxQrcode.getAccountOriginId());
        WxMpService wxMpService = WxMpServiceUtils.getWxMpServiceByAccount(account);
        WxMpQrCodeTicket ticket = wxMpService.getQrcodeService().qrCodeCreateLastTicket(wxQrcode.getSceneStr());
        File qrcodePicture = wxMpService.getQrcodeService().qrCodePicture(ticket);
        FileData attachment = new FileData();
        attachment.setFileName("wxQrcode.jpg");
        attachment.setFileSuffix("jpg");
        FileManagerFactory.getFileManager().write(qrcodePicture, attachment);
        if (StringUtils.isBlank((String)wxQrcode.getName())) {
            wxQrcode.setName("qrcode" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        }
        wxQrcode.setType(WxQrcode.QRCODE_TYPE_UNLIMIT);
        wxQrcode.setImgUrl(attachment.getFileUrl());
        wxQrcode.setTicket(ticket.getTicket());
        wxQrcode.setContent(ticket.getUrl());
        this.addObj(wxQrcode);
        return wxQrcode;
    }

    public void createHandleRuleForQrcode(WxQrcode wxQrcode) {
        WxMsgRule wxMsgRule = new WxMsgRule();
        wxMsgRule.setMsgType("event");
        wxMsgRule.setEventKey(wxQrcode.getSceneStr());
        wxMsgRule.setHandlers(wxQrcode.getReplyType());
        wxMsgRule.setReplyContent(wxQrcode.getReplyContent());
        wxMsgRule.setWxAccountId(wxQrcode.getAccountId());
        wxMsgRule.setWxAccountOriginId(wxQrcode.getAccountOriginId());
        wxMsgRule.setName("qrcode_auto_created" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        this.wxMsgRuleService.addObj(wxMsgRule);
        WxQrcode record = new WxQrcode();
        record.setId(wxQrcode.getId());
        record.setHandlerId(wxMsgRule.getId());
        this.wxQrcodeMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    @Cacheable(value={"wxQrcode"}, key="'WxQrcodeService_' + #root.methodName + '_'+ #originId +'_'+ #scene")
    public WxQrcode queryByKey(String originId, String scene) {
        WxQrcodeExample example = new WxQrcodeExample();
        example.createCriteria().andSceneStrEqualTo(scene).andAccountOriginIdEqualTo(originId);
        List<WxQrcode> list = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    @CacheEvict(value={"wxQrcode"}, allEntries=true)
    public void addScanQrcode(String id) {
        this.wxQrcodeMapper.addScanCount(id);
    }

    @CacheEvict(value={"wxQrcode"}, allEntries=true)
    public void deleteByExample(WxQrcodeExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.wxQrcodeMapper.deleteByExample(example);
    }

    @CacheEvict(value={"wxQrcode"}, allEntries=true)
    @Transactional
    public void addAll(List<WxQrcode> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.wxQrcodeMapper.insertSelective((WxQrcode)record));
    }
}

