/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.common;

import com.els.base.wechat.account.entity.AccountConfig;
import java.util.Hashtable;
import java.util.Map;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import org.apache.commons.lang.StringUtils;

public class WxMpServiceUtils {
    public static final ThreadLocal<WxMpService> wxMpServiceThreadLocal = new ThreadLocal();
    public static Map<String, WxMpService> wxMpServiceMap = new Hashtable<String, WxMpService>();

    public static void setInThreadLocal(WxMpService wxMpService) {
        wxMpServiceThreadLocal.set(wxMpService);
    }

    public static WxMpService getWxMpServiceFromThreadLocal() {
        return wxMpServiceThreadLocal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WxMpService getWxMpServiceByAccount(AccountConfig accountConfig) {
        if (accountConfig == null) {
            return null;
        }
        String appId = accountConfig.getAppId();
        if (StringUtils.isBlank((String)appId)) {
            throw new NullPointerException("\u516c\u4f17\u53f7\u914d\u7f6e\u4e2d\uff0cappid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (wxMpServiceMap.get(appId) != null) {
            return wxMpServiceMap.get(appId);
        }
        Map<String, WxMpService> map = wxMpServiceMap;
        synchronized (map) {
            if (wxMpServiceMap.get(appId) == null) {
                WxMpServiceImpl service = new WxMpServiceImpl();
                service.setWxMpConfigStorage(accountConfig.getWxMpConfigStorage());
                wxMpServiceMap.put(appId, (WxMpService)service);
            }
        }
        return wxMpServiceMap.get(appId);
    }
}

