/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.common;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import me.chanjar.weixin.common.api.WxMessageDuplicateChecker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMsgDeuplicateChecker
implements WxMessageDuplicateChecker {
    private static Logger logger = LoggerFactory.getLogger(CustomMsgDeuplicateChecker.class);
    public static final String MSG_STATUS_PROCESS = "processing";
    public static final String MSG_STATUS_ERROR = "error";
    public static final String MSG_STATUS_FINISH = "finish";
    private static final long EXPIRED_TIME = 60000L;
    private boolean isVailable = true;
    private Map<String, String> msgAndStatus = new Hashtable<String, String>();

    public CustomMsgDeuplicateChecker() {
        this.startClean();
    }

    public boolean isDuplicate(String messageId) {
        String status = this.getMsgStatus(messageId);
        if (StringUtils.isBlank((String)status) || MSG_STATUS_ERROR.equals(status)) {
            return false;
        }
        logger.warn("receive a repeat msg[" + messageId + "] ,status[" + status + "]");
        return true;
    }

    public void setMsgStatus(String msgId, String status) {
        if (StringUtils.isBlank((String)status) || !MSG_STATUS_ERROR.equals(status) && !MSG_STATUS_FINISH.equals(status) && !MSG_STATUS_PROCESS.equals(status)) {
            throw new IllegalArgumentException("msg status is illegal!!!");
        }
        long currentTime = System.currentTimeMillis();
        String timeAndStatus = status + "_" + currentTime;
        this.msgAndStatus.put(msgId, timeAndStatus);
    }

    protected String getMsgStatus(String msgId) {
        String timeAndStatus = this.msgAndStatus.get(msgId);
        if (StringUtils.isBlank((String)timeAndStatus) || !timeAndStatus.matches("\\w+_\\d+")) {
            return null;
        }
        return timeAndStatus.split("_")[0];
    }

    protected Long getMsgTime(String msgId) {
        String timeAndStatus = this.msgAndStatus.get(msgId);
        if (StringUtils.isBlank((String)timeAndStatus) || !timeAndStatus.matches("\\w+_\\d+")) {
            return null;
        }
        return Long.valueOf(timeAndStatus.split("_")[1]);
    }

    protected void cleanExpiredMsgId() {
        logger.debug("start clean wx msgAndStatusPool,size[" + this.msgAndStatus.size() + "]");
        HashSet keySet = new HashSet();
        CollectionUtils.addAll(keySet, this.msgAndStatus.keySet().iterator());
        for (String key : keySet) {
            Long time = this.getMsgTime(key);
            if (time != null && System.currentTimeMillis() - time <= 60000L) continue;
            this.msgAndStatus.remove(key);
        }
        logger.debug("finish clean wx msgAndStatusPool,size[" + this.msgAndStatus.size() + "]");
    }

    public void stopClean() {
        this.isVailable = false;
    }

    private void startClean() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (CustomMsgDeuplicateChecker.this.isVailable) {
                        CustomMsgDeuplicateChecker.this.cleanExpiredMsgId();
                        Thread.sleep(60000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }, "Thread-McodingMsgDeuplicateChecker");
        thread.start();
    }
}

