/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.msg.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.wechat.msg.entity.WxMsgAutoReply;
import com.els.base.wechat.msg.entity.WxMsgAutoReplyExample;
import com.els.base.wechat.msg.service.WxMsgAutoReplyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u5fae\u4fe1-\u81ea\u52a8\u56de\u590d\u7684\u6d88\u606f\u89c4\u5219"})
@Controller
@RequestMapping(value={"wxMsgAutoReply"})
public class WxMsgAutoReplyController {
    @Resource
    protected WxMsgAutoReplyService wxMsgAutoReplyService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u81ea\u52a8\u56de\u590d\u7684\u6d88\u606f\u89c4\u5219")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody WxMsgAutoReply wxMsgAutoReply) {
        String originId = wxMsgAutoReply.getWxAccountOriginId();
        WxMsgAutoReplyExample example = new WxMsgAutoReplyExample();
        example.createCriteria().andWxAccountOriginIdEqualTo(originId).andIsDefaultEqualTo(Constant.YES_INT);
        List liset = this.wxMsgAutoReplyService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)liset)) {
            wxMsgAutoReply.setIsDefault(Constant.YES_INT);
        }
        this.wxMsgAutoReplyService.addObj(wxMsgAutoReply);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u81ea\u52a8\u56de\u590d\u7684\u6d88\u606f\u89c4\u5219")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody WxMsgAutoReply wxMsgAutoReply) {
        if (wxMsgAutoReply.getId() == null || wxMsgAutoReply.getId() <= 0) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.wxMsgAutoReplyService.modifyObj(wxMsgAutoReply);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u5220\u9664\u81ea\u52a8\u56de\u590d\u7684\u6d88\u606f\u89c4\u5219")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(int id) {
        this.wxMsgAutoReplyService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u8bbe\u7f6e\u9ed8\u8ba4\u7684\u81ea\u52a8\u56de\u590d\u5185\u5bb9")
    @RequestMapping(value={"service/setDefaultById"})
    @ResponseBody
    public ResponseResult<String> setDefaultById(@RequestParam(required=true, name="originId") String originId, int id) {
        this.wxMsgAutoReplyService.setDefalutById(originId, id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u81ea\u52a8\u56de\u590d\u7684\u6d88\u606f\u89c4\u5219")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<WxMsgAutoReply>> findByPage(@ApiParam(value="\u5206\u9875\u7d22\u5f15", defaultValue="0") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestParam(required=true, name="originId") String originId, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") String sSearch) {
        PageView pageView = new PageView(pageNo, pageSize);
        WxMsgAutoReplyExample example = new WxMsgAutoReplyExample();
        example.setPageView((PageView<WxMsgAutoReply>)pageView);
        if (StringUtils.isNotBlank((String)sSearch)) {
            // empty if block
        }
        example.createCriteria().andWxAccountOriginIdEqualTo(originId);
        return ResponseResult.success((Object)this.wxMsgAutoReplyService.queryObjByPage((IExample)example));
    }
}

