/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.oauth.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.utils.SpringContextHolder;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.entity.AccountConfigExample;
import com.els.base.wechat.account.service.AccountConfigService;
import com.els.base.wechat.account.utils.WxAccountConfigUtils;
import com.els.base.wechat.common.WxMpServiceUtils;
import com.els.base.wechat.member.service.WxMemberService;
import com.els.base.wechat.oauth.service.WechatOauthService;
import com.els.base.wechat.oauth.utils.WechatOauthUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u5fae\u4fe1-\u516c\u4f17\u53f7\u7f51\u9875\u6388\u6743\u63a5\u53e3")
@Controller
public class WechatOauthController {
    private static Logger logger = LoggerFactory.getLogger(WechatOauthController.class);
    private static final Pattern urlPatther = Pattern.compile("((http|https):\\/\\/.+)?\\?(.+)");
    private static final Pattern tuPattern = Pattern.compile("((\\w+):(.+?))[\\,\\}]");
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static String defaultPage;
    @Autowired
    protected AccountConfigService accountConfigService;
    @Autowired
    private WxMemberService wxMemberService;

    @ApiIgnore
    @RequestMapping(value={"/wechatOauth/front/oauth2Openid/{params}"})
    public ModelAndView receiveOpenid(@PathVariable(value="params") String params, String code, HttpServletRequest request, HttpServletResponse response) throws WxErrorException {
        logger.debug("receive wechat post code :" + code + ", with params :" + params);
        Map<String, String> paramsMap = this.getParamsMapFromState(params);
        AccountConfig accountConfig = this.accountConfigService.queryByOriginId(paramsMap.get("APPID"));
        WxMpService wxMpService = WxMpServiceUtils.getWxMpServiceByAccount(accountConfig);
        logger.debug("wxMpService:" + wxMpService + ",account:" + accountConfig);
        WxMpOAuth2AccessToken wxMpOAuth2AccessToken = wxMpService.oauth2getAccessToken(code);
        String openId = wxMpOAuth2AccessToken.getOpenId();
        WxMpUser wxMpUser = this.getWxMpUserByOpenId(openId, wxMpService);
        this.wxMemberService.createOrEditWxMember(wxMpUser, null, accountConfig.getOriginId());
        request.getSession().setAttribute("openid", (Object)openId);
        this.handleWithOpenidAndParamsMap(openId, paramsMap, request, response);
        String viewName = this.getRedirectUrl(paramsMap);
        paramsMap.put("openid", openId);
        paramsMap.remove("TU");
        return new ModelAndView(viewName, paramsMap);
    }

    @ApiIgnore
    @RequestMapping(value={"/wechatOauth/front/oauth2WxUserInfo/{params}"})
    public ModelAndView receiveCodeAndGetWxUserInfo(@PathVariable(value="params") String params, String code, HttpServletRequest request, HttpServletResponse response) throws WxErrorException {
        logger.debug("receive wechat post code :" + code + ", with params :" + params);
        long t1 = System.currentTimeMillis();
        Map<String, String> paramsMap = this.getParamsMapFromState(params);
        AccountConfig accountConfig = this.accountConfigService.queryByOriginId(paramsMap.get("APPID"));
        WxMpService wxMpService = WxMpServiceUtils.getWxMpServiceByAccount(accountConfig);
        WxMpOAuth2AccessToken wxMpOAuth2AccessToken = wxMpService.oauth2getAccessToken(code);
        logger.debug("get oAuth2 AccessToken, cost [{}ms], AccessToken:", (Object)(System.currentTimeMillis() - t1), (Object)wxMpOAuth2AccessToken);
        long t2 = System.currentTimeMillis();
        WxMpUser wxMpUser = wxMpService.oauth2getUserInfo(wxMpOAuth2AccessToken, null);
        String openId = wxMpOAuth2AccessToken.getOpenId();
        request.getSession().setAttribute("openid", (Object)openId);
        logger.debug("get userinfo cost[{}ms], userInfo", (Object)(System.currentTimeMillis() - t2), (Object)wxMpUser);
        this.wxMemberService.createOrEditWxMember(wxMpUser, null, accountConfig.getOriginId());
        this.handleWithWxUserAndParamsMap(wxMpUser, paramsMap, request, response);
        String viewName = this.getRedirectUrl(paramsMap);
        request.getSession().setAttribute("openid", (Object)openId);
        request.getSession().setAttribute("wxMpUser", (Object)wxMpUser);
        paramsMap.put("openid", openId);
        paramsMap.remove("TU");
        return new ModelAndView(viewName, paramsMap);
    }

    private String getRedirectUrl(Map<String, String> paramsMap) {
        String targetUrl = null;
        if (paramsMap != null) {
            targetUrl = paramsMap.get("TU");
        }
        String serverName = StringUtils.substringBefore((String)StringUtils.substringBetween(targetUrl, (String)"://", (String)"/"), (String)":");
        if (StringUtils.isBlank((String)targetUrl)) {
            targetUrl = serverName + defaultPage;
        } else if (targetUrl.startsWith("/")) {
            targetUrl = serverName + targetUrl;
        }
        return "redirect:" + targetUrl;
    }

    private void handleWithOpenidAndParamsMap(String openId, Map<String, String> paramsMap, HttpServletRequest request, HttpServletResponse response) {
        ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();
        Map beanMaps = applicationContext.getBeansOfType(WechatOauthService.class);
        if (MapUtils.isEmpty((Map)beanMaps)) {
            return;
        }
        Set beanSet = beanMaps.keySet();
        Iterator iterator = beanSet.iterator();
        while (iterator.hasNext()) {
            ((WechatOauthService)beanMaps.get(iterator.next())).handleForOpenId(openId, paramsMap, request, response);
        }
    }

    private void handleWithWxUserAndParamsMap(WxMpUser wxMpUser, Map<String, String> paramsMap, HttpServletRequest request, HttpServletResponse response) {
        ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();
        Map beanMaps = applicationContext.getBeansOfType(WechatOauthService.class);
        if (MapUtils.isEmpty((Map)beanMaps)) {
            return;
        }
        Set beanSet = beanMaps.keySet();
        Iterator iterator = beanSet.iterator();
        while (iterator.hasNext()) {
            ((WechatOauthService)beanMaps.get(iterator.next())).handleForWxUser(wxMpUser, paramsMap, request, response);
        }
    }

    private WxMpUser getWxMpUserByOpenId(String openId, WxMpService wxMpService) {
        WxMpUser wxMpUser = null;
        try {
            wxMpUser = wxMpService.getUserService().userInfo(openId);
        }
        catch (WxErrorException e) {
            logger.warn("\u5411\u516c\u4f17\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        if (wxMpUser == null) {
            wxMpUser = new WxMpUser();
            wxMpUser.setOpenId(openId);
        }
        return wxMpUser;
    }

    private Map<String, String> getParamsMapFromState(String params) {
        Hashtable<String, String> paramsMap = new Hashtable();
        if (StringUtils.isBlank((String)params)) {
            return null;
        }
        byte[] byteArray = Base64.decodeBase64((String)params);
        if (!(params = new String(byteArray)).contains("\"")) {
            Matcher tuMatcher = tuPattern.matcher(params);
            while (tuMatcher.find()) {
                String key = tuMatcher.group(2);
                String value = tuMatcher.group(3);
                if (!StringUtils.isNotBlank((String)key)) continue;
                paramsMap.put(key, value);
            }
            return paramsMap;
        }
        try {
            paramsMap = (Map)objectMapper.readValue(params, Map.class);
            logger.debug("get map from json :" + paramsMap);
        }
        catch (IOException e) {
            logger.warn("\u89e3\u6790\u5fae\u4fe1\u8fd4\u56de\u7684state\u5931\u8d25", (Throwable)e);
        }
        return paramsMap;
    }

    @ApiOperation(httpMethod="GET", value="\u83b7\u53d6\u6388\u6743openid\u7684\u8df3\u8f6c\u5730\u5740")
    @RequestMapping(value={"wechatOauth/front/createOauthUrlForOpenid"})
    @ResponseBody
    public ResponseResult<String> createOauthUrlForOpenid(@ApiParam(value="\u6388\u6743\u7684\u9875\u9762") String url, @ApiParam(value="\u5fae\u4fe1\u516c\u4f17\u53f7\u7684\u539f\u59cbid\uff0c\u53ef\u4ee5\u4e0d\u586b") String originId, HttpServletRequest request) throws Exception {
        Map<String, String> paramsMap = this.createUrlParamMap(url);
        String targetUrl = this.getTargetUrl(url);
        AccountConfig accountConfig = this.getAccountByOriginIdOrUrl(originId, targetUrl);
        if (accountConfig == null) {
            throw new CommonException("\u7cfb\u7edf\u6ca1\u6709\u5408\u9002\u7684\u516c\u4f17\u53f7\u914d\u7f6e");
        }
        String oauthUrl = WechatOauthUtils.createOauthUrlForOpenid(targetUrl, paramsMap, accountConfig);
        return ResponseResult.success((Object)oauthUrl);
    }

    @ApiOperation(httpMethod="GET", value="\u83b7\u53d6\u4f1a\u5458\u8d44\u6599\u7684\u8df3\u8f6c\u5730\u5740")
    @RequestMapping(value={"wechatOauth/front/createOauthUrlForWxUserInfo"})
    @ResponseBody
    public ResponseResult<String> createOauthUrlForWxUserInfo(@ApiParam(value="\u6388\u6743\u7684\u9875\u9762") @RequestParam(required=true) String url, @ApiParam(value="\u5fae\u4fe1\u516c\u4f17\u53f7\u7684\u539f\u59cbid\uff0c\u53ef\u4ee5\u4e0d\u586b") String originId, HttpServletRequest request) throws Exception {
        Map<String, String> paramsMap = this.createUrlParamMap(url);
        String targetUrl = this.getTargetUrl(url);
        AccountConfig accountConfig = this.getAccountByOriginIdOrUrl(originId, targetUrl);
        if (accountConfig == null) {
            throw new CommonException("\u7cfb\u7edf\u6ca1\u6709\u5408\u9002\u7684\u516c\u4f17\u53f7\u914d\u7f6e");
        }
        String oauthUrl = WechatOauthUtils.createOauthUrlForWxUserInfo(targetUrl, paramsMap, accountConfig);
        return ResponseResult.success((Object)oauthUrl);
    }

    private AccountConfig getAccountByOriginIdOrUrl(String originId, String url) {
        AccountConfigExample example;
        List list;
        AccountConfig accountConfig = null;
        if (StringUtils.isNotBlank((String)originId)) {
            accountConfig = WxAccountConfigUtils.getByOrginId(originId);
        }
        if (accountConfig == null) {
            String serverName = StringUtils.substringBetween((String)url, (String)"://", (String)"/");
            String requestUri = url.replaceAll("https?://.+?/", "/");
            accountConfig = this.accountConfigService.queryByRequest("http", serverName, 80, requestUri);
        }
        if (accountConfig == null && CollectionUtils.isNotEmpty((Collection)(list = this.accountConfigService.queryAllObjByExample((IExample)(example = new AccountConfigExample())))) && list.size() == 1) {
            accountConfig = (AccountConfig)list.get(0);
        }
        return accountConfig;
    }

    private Map<String, String> createUrlParamMap(String url) {
        Matcher matcher = urlPatther.matcher(url);
        if (!matcher.find()) {
            return null;
        }
        HashMap<String, String> urlParamsMap = new HashMap<String, String>();
        List list = URLEncodedUtils.parse((String)matcher.group(3), (Charset)Charset.forName("utf-8"));
        for (int i = 0; i < list.size(); ++i) {
            NameValuePair params = (NameValuePair)list.get(i);
            System.out.println("name" + params.getName() + ",value" + params.getValue());
            urlParamsMap.put(params.getName(), params.getValue());
        }
        return urlParamsMap;
    }

    private String getTargetUrl(String url) {
        Matcher matcher = urlPatther.matcher(url);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return url;
    }
}

