/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.msg.handler;

import com.els.base.utils.SpringContextHolder;
import com.els.base.wechat.msg.entity.WxMsgReplyNews;
import com.els.base.wechat.msg.entity.WxMsgRule;
import com.els.base.wechat.msg.handler.BaseMsgHandler;
import com.els.base.wechat.msg.service.WxMsgReplyNewsService;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutNewsMessage;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ReplyNewsHandler
extends BaseMsgHandler {
    private List<WxMpXmlOutNewsMessage.Item> articleList;

    public ReplyNewsHandler(WxMsgRule wxMsgRule) throws JsonParseException, JsonMappingException, IOException {
        super(wxMsgRule);
        String content = wxMsgRule.getReplyContent();
        if (StringUtils.isBlank((String)content)) {
            return;
        }
        this.articleList = new ArrayList<WxMpXmlOutNewsMessage.Item>();
        String[] ids = content.split("\\s*,\\s*");
        for (int i = 0; i < ids.length; ++i) {
            WxMsgReplyNews msgNews = (WxMsgReplyNews)((WxMsgReplyNewsService)SpringContextHolder.getOneBean(WxMsgReplyNewsService.class)).queryObjById(Integer.valueOf(ids[i]));
            WxMpXmlOutNewsMessage.Item item = new WxMpXmlOutNewsMessage.Item();
            item.setTitle(msgNews.getTitle());
            item.setPicUrl(msgNews.getCoverImg());
            item.setDescription(msgNews.getSummary());
            item.setUrl(msgNews.getUrl());
            this.articleList.add(item);
        }
    }

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService, WxSessionManager sessionManager) throws WxErrorException {
        WxMpXmlOutNewsMessage newsMsg = new WxMpXmlOutNewsMessage();
        newsMsg.setFromUserName(wxMessage.getToUser());
        newsMsg.setToUserName(wxMessage.getFromUser());
        newsMsg.setMsgType("news");
        newsMsg.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        for (int i = 0; CollectionUtils.isNotEmpty(this.articleList) && i < this.articleList.size(); ++i) {
            newsMsg.addArticle(this.articleList.get(i));
        }
        return newsMsg;
    }
}

