/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.qrcode.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.wechat.qrcode.entity.WxQrcode;
import com.els.base.wechat.qrcode.entity.WxQrcodeExample;
import com.els.base.wechat.qrcode.service.WxQrcodeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Date;
import javax.annotation.Resource;
import me.chanjar.weixin.common.exception.WxErrorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u5fae\u4fe1-\u5173\u6ce8\u516c\u4f17\u53f7\u4e8c\u7ef4\u7801"})
@Controller
@RequestMapping(value={"wxQrcode"})
public class WechatQrcodeController {
    @Resource
    protected WxQrcodeService wxQrcodeService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5fae\u4fe1\u4e8c\u7ef4\u7801")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody WxQrcode wxQrcode) throws NumberFormatException, WxErrorException, IOException {
        if (StringUtils.isBlank((String)wxQrcode.getName())) {
            throw new CommonException("\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!WxQrcode.QRCODE_TYPE_LIMIT.equals(wxQrcode.getType()) && !WxQrcode.QRCODE_TYPE_UNLIMIT.equals(wxQrcode.getType())) {
            throw new CommonException("\u5fae\u4fe1\u4e8c\u7ef4\u7801\u7684\u7c7b\u578b\u5f02\u5e38");
        }
        if (WxQrcode.QRCODE_TYPE_LIMIT.equals(wxQrcode.getType())) {
            if (wxQrcode.getValidHours() == null || wxQrcode.getValidHours() <= 0) {
                wxQrcode.setValidHours(720);
            }
            wxQrcode.setValidTime(DateUtils.addHours((Date)new Date(), (int)wxQrcode.getValidHours()));
            wxQrcode.setSceneStr(String.valueOf(System.currentTimeMillis() / 1000L));
            this.wxQrcodeService.createLimitQrcode(wxQrcode);
        } else {
            wxQrcode.setSceneStr("UNLIMIT_" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddhhmmss"));
            this.wxQrcodeService.createUnLimitQrcode(wxQrcode);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5fae\u4fe1\u4e8c\u7ef4\u7801")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody WxQrcode wxQrcode) {
        if (StringUtils.isBlank((String)wxQrcode.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.wxQrcodeService.modifyObj(wxQrcode);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5fae\u4fe1\u4e8c\u7ef4\u7801")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        this.wxQrcodeService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5fae\u4fe1\u4e8c\u7ef4\u7801")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<WxQrcode>> findByPage(@ApiParam(name="\u5206\u9875\u7d22\u5f15", defaultValue="0") @RequestParam(defaultValue="1") int pageNo, @ApiParam(name="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(name="\u516c\u4f17\u53f7\u539f\u59cbid") @RequestParam(required=true, value="originId") String originId, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") String sSearch) {
        PageView pageView = new PageView(pageNo, pageSize);
        WxQrcodeExample example = new WxQrcodeExample();
        example.createCriteria().andAccountOriginIdEqualTo(originId);
        example.setPageView((PageView<WxQrcode>)pageView);
        if (StringUtils.isNotBlank((String)sSearch)) {
            // empty if block
        }
        return ResponseResult.success((Object)this.wxQrcodeService.queryObjByPage((IExample)example));
    }
}

