/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.member.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.wechat.member.dao.WxMemberMapper;
import com.els.base.wechat.member.entity.WxMember;
import com.els.base.wechat.member.entity.WxMemberExample;
import com.els.base.wechat.member.service.WxMemberService;
import com.els.base.wechat.member.utils.WxMemberUtils;
import java.util.Date;
import java.util.List;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="wxMemberService")
public class WxMemberServiceImpl
implements WxMemberService {
    private static Logger logger = LoggerFactory.getLogger(WxMemberServiceImpl.class);
    @Autowired
    private WxMemberMapper wxMemberMapper;

    @CacheEvict(value={"wxMember"}, allEntries=true)
    public void addObj(WxMember t) {
        this.wxMemberMapper.insertSelective(t);
    }

    @CacheEvict(value={"wxMember"}, allEntries=true)
    public void deleteObjById(String id) {
        this.wxMemberMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"wxMember"}, allEntries=true)
    public void modifyObj(WxMember t) {
        if (t.getId() == null) {
            throw new NullPointerException("id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.wxMemberMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"wxMember"}, key="'WxMember_' +#root.methodName + '_' + #id")
    public WxMember queryObjById(String id) {
        return this.wxMemberMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"wxMember"}, key="'WxMember_' +#root.methodName + '_' + #example.toJson()")
    public List<WxMember> queryAllObjByExample(WxMemberExample example) {
        return this.wxMemberMapper.selectByExample(example);
    }

    @Cacheable(value={"wxMember"}, key="'WxMember_' +#root.methodName + '_' + #example.toJson()")
    public PageView<WxMember> queryObjByPage(WxMemberExample example) {
        PageView pageView = example.getPageView();
        if (pageView == null) {
            pageView = new PageView(1, 10);
        }
        pageView.setQueryResult(this.wxMemberMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"wxMember"}, allEntries=true)
    public WxMember createOrEditWxMember(WxMpUser wxMpUser) {
        return this.createOrEditWxMember(wxMpUser, null, null);
    }

    @Override
    @CacheEvict(value={"wxMember"}, allEntries=true)
    public WxMember createOrEditWxMember(WxMpUser wxMpUser, String subscribeKey, String originId) {
        WxMember wxMember = WxMemberUtils.getWxMemberFormMpUser(wxMpUser);
        wxMember.setWxAccountOriginId(originId);
        String openid = wxMpUser.getOpenId();
        WxMemberExample wxMemberExample = new WxMemberExample();
        wxMemberExample.createCriteria().andWxOpenidEqualTo(openid);
        List<WxMember> list = this.queryAllObjByExample(wxMemberExample);
        if (CollectionUtils.isEmpty(list)) {
            if (Constant.YES_INT.equals(wxMember.getWxSubscribe())) {
                wxMember.setWxFirstSubscribeTime(new Date());
            }
            wxMember.setWxSubscribeKey(subscribeKey);
            this.addObj(wxMember);
        } else {
            if (wxMember.getWxFirstSubscribeTime() == null && Constant.YES_INT.equals(wxMember.getWxSubscribe())) {
                wxMember.setWxFirstSubscribeTime(new Date());
                wxMember.setWxSubscribeKey(subscribeKey);
            }
            wxMember.setId(list.get(0).getId());
            this.modifyObj(wxMember);
            wxMember = this.queryObjById(list.get(0).getId());
        }
        return wxMember;
    }

    @Override
    @CacheEvict(value={"wxMember"}, allEntries=true)
    public void updateForUnsubscribe(String openid) {
        WxMemberExample example = new WxMemberExample();
        example.createCriteria().andWxOpenidEqualTo(openid);
        WxMember wxMember = new WxMember();
        wxMember.setWxSubscribe(Constant.NO_INT);
        this.wxMemberMapper.updateByExampleSelective(wxMember, example);
    }

    @Override
    @Cacheable(value={"wxMember"}, key="'WxMember_' +#root.methodName + '_' + #openid")
    public WxMember queryByOpenId(String openid) {
        WxMemberExample wxMemberExample = new WxMemberExample();
        wxMemberExample.createCriteria().andWxOpenidEqualTo(openid);
        List<WxMember> list = this.wxMemberMapper.selectByExample(wxMemberExample);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (list.size() > 1) {
            logger.warn("please pay attention on wxmember[" + openid + "], there are two or more same datas in database.");
        }
        return list.get(0);
    }

    @Override
    @CacheEvict(value={"wxMember"}, allEntries=true)
    @Transactional
    public void unTieMemberId(String id) {
        Assert.isNotBlank((String)id, (String)"\u7ed1\u5b9a\u7684ID\u4e0d\u80fd\u4e3a\u7a7a");
        WxMemberExample example = new WxMemberExample();
        example.createCriteria().andMemberIdEqualTo(id);
        List<WxMember> list = this.wxMemberMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (WxMember wxMember : list) {
            wxMember.setMemberId(null);
            this.wxMemberMapper.updateByPrimaryKey(wxMember);
        }
    }

    @CacheEvict(value={"wxMember"}, allEntries=true)
    public void deleteByExample(WxMemberExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.wxMemberMapper.deleteByExample(example);
    }

    @CacheEvict(value={"wxMember"}, allEntries=true)
    @Transactional
    public void addAll(List<WxMember> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.wxMemberMapper.insertSelective((WxMember)record));
    }
}

