/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.redpack.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.service.AccountConfigService;
import com.els.base.wechat.common.WxPayServiceUtils;
import com.els.base.wechat.redpack.RedpackSender;
import com.els.base.wechat.redpack.dao.WxRedpackSendRecordMapper;
import com.els.base.wechat.redpack.entity.WxRedpackSendRecord;
import com.els.base.wechat.redpack.entity.WxRedpackSendRecordExample;
import com.els.base.wechat.redpack.service.WxRedpackSendRecordService;
import com.github.binarywang.wxpay.bean.request.WxPaySendRedpackRequest;
import com.github.binarywang.wxpay.bean.result.WxPayRedpackQueryResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.RandomUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="wxRedpackSendRecordService")
public class WxRedpackSendRecordServiceImpl
implements WxRedpackSendRecordService {
    @Value(value="${wechat.pay.mode.debug:false}")
    private Boolean openPennyToBuy;
    @Autowired
    private AccountConfigService accountConfigService;
    @Resource
    protected WxRedpackSendRecordMapper wxRedpackSendRecordMapper;

    @CacheEvict(value={"wxRedpackSendRecord"}, allEntries=true)
    public void addObj(WxRedpackSendRecord t) {
        this.wxRedpackSendRecordMapper.insertSelective(t);
    }

    @CacheEvict(value={"wxRedpackSendRecord"}, allEntries=true)
    public void deleteObjById(Integer id) {
        this.wxRedpackSendRecordMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"wxRedpackSendRecord"}, allEntries=true)
    public void modifyObj(WxRedpackSendRecord t) {
        if (t.getId() == null || t.getId() == 0) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.wxRedpackSendRecordMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"wxRedpackSendRecord"}, key="'WxRedpackSendRecordService_' + #root.methodName + '_' +#id")
    public WxRedpackSendRecord queryObjById(Integer id) {
        return this.wxRedpackSendRecordMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"wxRedpackSendRecord"}, key="'WxRedpackSendRecordService_' + #root.methodName + '_'+ #example.toJson()")
    public List<WxRedpackSendRecord> queryAllObjByExample(WxRedpackSendRecordExample example) {
        return this.wxRedpackSendRecordMapper.selectByExample(example);
    }

    @Cacheable(value={"wxRedpackSendRecord"}, key="'WxRedpackSendRecordService_' + #root.methodName + '_'+ #example.toJson()")
    public PageView<WxRedpackSendRecord> queryObjByPage(WxRedpackSendRecordExample example) {
        PageView pageView = example.getPageView();
        if (pageView == null) {
            pageView = new PageView(1, 10);
            example.setPageView((PageView<WxRedpackSendRecord>)pageView);
        }
        pageView.setQueryResult(this.wxRedpackSendRecordMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"wxRedpackSendRecord"}, allEntries=true)
    public String syncStatus(WxRedpackSendRecord wxRedpackSendRecord) throws WxPayException {
        AccountConfig accountConfig = (AccountConfig)this.accountConfigService.queryObjById(wxRedpackSendRecord.getAccountId());
        WxPayService wxMpService = WxPayServiceUtils.getWxPayServiceByAccount(accountConfig);
        WxPayRedpackQueryResult result = wxMpService.queryRedpack(wxRedpackSendRecord.getBillNo());
        if (result.getStatus().equals(wxRedpackSendRecord.getStatus())) {
            return result.getStatus();
        }
        Date receiveTime = null;
        WxRedpackSendRecord tmp = new WxRedpackSendRecord();
        tmp.setId(wxRedpackSendRecord.getId());
        tmp.setStatus(result.getStatus());
        tmp.setReceiveTime(receiveTime);
        this.modifyObj(tmp);
        return result.getStatus();
    }

    @Override
    @Cacheable(value={"wxRedpackSendRecord"}, key="'WxRedpackSendRecordService_' + #root.methodName + '_'+ #billNo")
    public WxRedpackSendRecord queryByBillNo(String billNo) {
        WxRedpackSendRecordExample example = new WxRedpackSendRecordExample();
        example.createCriteria().andBillNoEqualTo(billNo);
        List<WxRedpackSendRecord> list = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    @Cacheable(value={"wxRedpackSendRecord"}, key="'WxRedpackSendRecordService_' + #root.methodName + '_'+ #example.toJson()")
    public Map<String, Integer> countStatus(WxRedpackSendRecordExample example) {
        List<Map<String, Integer>> list = this.wxRedpackSendRecordMapper.countStatus(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    @CacheEvict(value={"wxRedpackSendRecord"}, allEntries=true)
    public void sendRedpack(int recordId) throws UnknownHostException, WxErrorException {
        WxRedpackSendRecord record = this.queryObjById(recordId);
        this.sendRedpack(record);
    }

    @Override
    @CacheEvict(value={"wxRedpackSendRecord"}, allEntries=true)
    public void sendRedpack(WxRedpackSendRecord record) throws UnknownHostException, WxErrorException {
        if (!("FAILED".equals(record.getStatus()) || "REFUND".equals(record.getStatus()) || "UNSENT".equals(record.getStatus()))) {
            throw new CommonException("\u8be5\u7ea2\u5305\u5df2\u7ecf\u53d1\u51fa\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1");
        }
        if ("REFUND".equals(record.getStatus()) || "FAILED".equals(record.getStatus())) {
            String newBillNo = record.getBillNo().replaceAll("^\\d+S", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd") + "S");
            WxRedpackSendRecord tmp = new WxRedpackSendRecord();
            tmp.setId(record.getId());
            tmp.setBillNo(newBillNo);
            this.modifyObj(tmp);
            record.setBillNo(newBillNo);
        }
        AccountConfig accountConfig = (AccountConfig)this.accountConfigService.queryObjById(record.getAccountId());
        WxPaySendRedpackRequest outMessage = new WxPaySendRedpackRequest();
        outMessage.setNonceStr(RandomUtils.getRandomStr());
        outMessage.setMchId(accountConfig.getMchId());
        outMessage.setAppid(accountConfig.getAppId());
        outMessage.setTotalNum(Integer.valueOf(1));
        outMessage.setMchBillNo(record.getBillNo());
        outMessage.setSendName(StringUtils.defaultIfBlank((String)record.getSendName(), (String)accountConfig.getName()));
        outMessage.setReOpenid(record.getOpenid());
        outMessage.setWishing(record.getWishing());
        outMessage.setActName(record.getActName());
        outMessage.setRemark(record.getRemark());
        outMessage.setSceneId(record.getSceneId());
        if (this.openPennyToBuy != null && this.openPennyToBuy.booleanValue()) {
            outMessage.setTotalAmount(Integer.valueOf(100));
        } else {
            outMessage.setTotalAmount(record.getTotalAmount());
        }
        outMessage.setClientIp(InetAddress.getLocalHost().getHostAddress());
        RedpackSender.sendNormalRedpack(outMessage, accountConfig);
    }

    @CacheEvict(value={"wxRedpackSendRecord"}, allEntries=true)
    public void deleteByExample(WxRedpackSendRecordExample example) {
        Assert.isNotNull((Object)((Object)example), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.wxRedpackSendRecordMapper.deleteByExample(example);
    }

    @CacheEvict(value={"wxRedpackSendRecord"}, allEntries=true)
    @Transactional
    public void addAll(List<WxRedpackSendRecord> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.wxRedpackSendRecordMapper.insertSelective((WxRedpackSendRecord)record));
    }
}

