/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.jssdk.web.controller;

import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.service.AccountConfigService;
import com.els.base.wechat.common.WxMpServiceUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import me.chanjar.weixin.common.bean.WxCardApiSignature;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5fae\u4fe1-\u516c\u4f17\u53f7JS_SDK\u63a5\u53e3")
@Controller
@RequestMapping(value={"wechatJsSdk"})
public class WechatJsSdkController {
    @Resource
    protected AccountConfigService accountConfigService;

    @ApiOperation(value="\u83b7\u53d6js sdk\u7684\u914d\u7f6e\u4fe1\u606f", httpMethod="GET")
    @RequestMapping(value={"front/getJsConfigParams"})
    @ResponseBody
    public ResponseResult<Map<String, String>> getJsConfigParams(HttpServletRequest request, @ApiParam(value="\u516c\u4f17\u53f7\u914d\u7f6e\u7684originid") String originId, @ApiParam(value="\u5f53\u524d\u7f51\u9875\u7684URL\uff0c\u4e0d\u5305\u542b#\u53ca\u5176\u540e\u9762\u90e8\u5206") @RequestParam(required=true) String url) throws WxErrorException {
        String serverName = StringUtils.substringBetween((String)url, (String)"://", (String)"/");
        String requestUri = url.replaceAll("https?://.+?/", "/");
        AccountConfig accountConfig = this.accountConfigService.queryByRequest("http", serverName, 80, requestUri);
        WxMpService wxMpService = WxMpServiceUtils.getWxMpServiceByAccount(accountConfig);
        String jsapiTicket = wxMpService.getJsapiTicket();
        WxJsapiSignature jsSign = wxMpService.createJsapiSignature(url);
        Hashtable<String, String> jsapiParams = new Hashtable<String, String>();
        jsapiParams.put("appId", accountConfig.getAppId());
        jsapiParams.put("timestamp", String.valueOf(jsSign.getTimestamp()));
        jsapiParams.put("nonceStr", jsSign.getNonceStr());
        jsapiParams.put("signature", jsSign.getSignature());
        jsapiParams.put("ticket", jsapiTicket);
        return ResponseResult.success(jsapiParams);
    }

    @ApiOperation(value="\u62c9\u53d6\u9002\u7528\u5361\u5238\u5217\u8868\uff0c\u83b7\u53d6\u524d\u7aef\u914d\u7f6e\u53c2\u6570", httpMethod="GET")
    @RequestMapping(value={"front/getChooseCardParam"})
    @ResponseBody
    public ResponseResult<WxCardApiSignature> getChooseCardParam(HttpServletRequest request, @ApiParam(value="\u516c\u4f17\u53f7\u914d\u7f6e\u7684originid,\u975e\u5fc5\u586b") String originId, @ApiParam(value="\u95e8\u5e97ID\uff0c\u975e\u5fc5\u586b") String shopId, @ApiParam(value="\u5361\u5238\u7c7b\u578b\uff0c\u975e\u5fc5\u586b") String cardType, @ApiParam(value="\u5361\u5238ID,\u975e\u5fc5\u586b") String cardId) throws NoSuchAlgorithmException, WxErrorException {
        AccountConfig accountConfig = this.getAccountConfig(request);
        WxMpService wxMpService = WxMpServiceUtils.getWxMpServiceByAccount(accountConfig);
        ArrayList<String> paramList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)shopId)) {
            paramList.add(shopId);
        }
        if (StringUtils.isNotBlank((String)cardId)) {
            paramList.add(cardId);
        }
        if (StringUtils.isNotBlank((String)cardType)) {
            paramList.add(cardType);
        }
        String[] args = paramList.toArray(new String[paramList.size()]);
        WxCardApiSignature cardSignatrue = wxMpService.getCardService().createCardApiSignature(args);
        return ResponseResult.success((Object)cardSignatrue);
    }

    private AccountConfig getAccountConfig(HttpServletRequest request) {
        String originId = request.getParameter("originId");
        AccountConfig accountConfig = null;
        accountConfig = StringUtils.isBlank((String)originId) ? this.accountConfigService.queryByRequest(request.getScheme(), request.getServerName(), request.getServerPort(), request.getRequestURI()) : this.accountConfigService.queryByOriginId(originId);
        if (accountConfig == null) {
            throw new CommonException("\u672a\u5339\u914d\u5230\u5408\u9002\u7684\u516c\u4f17\u53f7\u914d\u7f6e");
        }
        return accountConfig;
    }
}

