/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.msg.handler;

import com.els.base.utils.SpringContextHolder;
import com.els.base.wechat.msg.entity.WxMsgRule;
import com.els.base.wechat.msg.handler.BaseMsgHandler;
import com.els.base.wechat.qrcode.entity.WxQrcode;
import com.els.base.wechat.qrcode.service.WxQrcodeService;
import java.util.Map;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanQrcodeHandler
extends BaseMsgHandler {
    private static Logger logger = LoggerFactory.getLogger(ScanQrcodeHandler.class);

    public ScanQrcodeHandler(WxMsgRule wxMsgRule) {
        super(wxMsgRule);
    }

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService, WxSessionManager sessionManager) throws WxErrorException {
        logger.debug("com.els.base.wechat.msg.handler.ScanQrcodeHandler.handle => {}", (Object)wxMessage);
        if (!"event".equals(wxMessage.getMsgType())) {
            return null;
        }
        if (!"SCAN".equals(wxMessage.getEvent()) && !"subscribe".equals(wxMessage.getEvent())) {
            return null;
        }
        String key = wxMessage.getEventKey().replaceAll("qrscene_", "");
        WxQrcodeService wxQrcodeService = (WxQrcodeService)SpringContextHolder.getOneBean(WxQrcodeService.class);
        WxQrcode wxQrcode = wxQrcodeService.queryByKey(wxMessage.getToUser(), key);
        if (wxQrcode != null) {
            wxQrcodeService.addScanQrcode(wxQrcode.getId());
        }
        return null;
    }
}

