/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.account.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.wechat.account.dao.AccountConfigMapper;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.entity.AccountConfigExample;
import com.els.base.wechat.account.service.AccountConfigService;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountConfigServiceImpl
implements AccountConfigService {
    private static Logger logger = LoggerFactory.getLogger(AccountConfigServiceImpl.class);
    private static final Pattern URL_PATTERN = Pattern.compile("http:\\/\\/([\\w\\.]+)(:(\\d+))*(\\/(\\w+)*)?");
    @Resource
    public AccountConfigMapper accountConfigMapper;

    @CacheEvict(value={"accountConfigCache"}, allEntries=true)
    public void addObj(AccountConfig t) {
        this.accountConfigMapper.insertSelective(t);
    }

    @CacheEvict(value={"accountConfigCache"}, allEntries=true)
    public void deleteObjById(String id) {
        this.accountConfigMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"accountConfigCache"}, allEntries=true)
    public void modifyObj(AccountConfig t) {
        if (t.getId() == null) {
            throw new NullPointerException("id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.accountConfigMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"accountConfigCache"}, keyGenerator="redisKeyGenerator")
    public AccountConfig queryObjById(String id) {
        return this.accountConfigMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"accountConfigCache"}, keyGenerator="redisKeyGenerator")
    public List<AccountConfig> queryAllObjByExample(AccountConfigExample example) {
        return this.accountConfigMapper.selectByExample(example);
    }

    @Cacheable(value={"accountConfigCache"}, keyGenerator="redisKeyGenerator")
    public PageView<AccountConfig> queryObjByPage(AccountConfigExample example) {
        PageView pageView = example.getPageView();
        if (pageView == null) {
            pageView = new PageView(1, 10);
        }
        pageView.setQueryResult(this.accountConfigMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"accountConfigCache"}, keyGenerator="redisKeyGenerator")
    public AccountConfig queryByRequest(String schemem, String serverName, Integer port, String requestUri) {
        String domain = schemem + "://" + serverName;
        AccountConfigExample example = new AccountConfigExample();
        example.createCriteria().andDomainLike(domain + "%");
        List<AccountConfig> list = this.accountConfigMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        String appName = null;
        int endIndex = requestUri.indexOf("/", 1);
        appName = endIndex < 0 ? requestUri : requestUri.substring(1, endIndex);
        AccountConfig defaultAc = null;
        AccountConfig accountConfig = null;
        for (int i = 0; i < list.size(); ++i) {
            Matcher matcher = URL_PATTERN.matcher(list.get(i).getDomain());
            if (!matcher.find()) continue;
            String domainInConfig = matcher.group(1);
            String appNameInConfig = matcher.group(5);
            if (StringUtils.isBlank((String)domainInConfig)) {
                logger.warn("account[" + list.get(i).getName() + "] config error, no domain config");
                continue;
            }
            if (!domainInConfig.equals(serverName) || StringUtils.isNotBlank((String)appNameInConfig) && !appNameInConfig.equals(appName)) continue;
            if (StringUtils.isBlank((String)appNameInConfig)) {
                defaultAc = list.get(i);
                continue;
            }
            if (!appNameInConfig.equals(appName)) continue;
            accountConfig = list.get(i);
            return accountConfig;
        }
        return defaultAc;
    }

    @Override
    @Cacheable(value={"accountConfigCache"}, keyGenerator="redisKeyGenerator")
    public AccountConfig queryByRequest(HttpServletRequest request) {
        return this.queryByRequest(request.getScheme(), request.getServerName(), request.getServerPort(), request.getRequestURI());
    }

    @Override
    @Cacheable(value={"accountConfigCache"}, keyGenerator="redisKeyGenerator")
    public AccountConfig queryByOriginId(String originId) {
        AccountConfigExample example = new AccountConfigExample();
        example.createCriteria().andOriginIdEqualTo(originId);
        List<AccountConfig> list = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (list.size() > 1) {
            throw new IllegalArgumentException("\u5fae\u4fe1\u516c\u4f17\u53f7\u914d\u7f6e\u5f02\u5e38\uff0ccode\u4e0d\u552f\u4e00\uff0c\u914d\u7f6e\u6709\u76f8\u540c\u7684code");
        }
        return list.get(0);
    }

    @CacheEvict(value={"accountConfigCache"}, allEntries=true)
    public void deleteByExample(AccountConfigExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.accountConfigMapper.deleteByExample(example);
    }

    @CacheEvict(value={"accountConfigCache"}, allEntries=true)
    @Transactional
    public void addAll(List<AccountConfig> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.accountConfigMapper.insertSelective((AccountConfig)record));
    }
}

