/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.common;

import com.els.base.wechat.account.entity.AccountConfig;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class WxPayServiceUtils {
    public static final ThreadLocal<WxPayService> WX_PAY_SERVICE_THREAD_LOCAL = new ThreadLocal();
    public static Map<String, WxPayService> wxPayServiceMap = new Hashtable<String, WxPayService>();

    public static void setInThreadLocal(WxPayService wxPayService) {
        WX_PAY_SERVICE_THREAD_LOCAL.set(wxPayService);
    }

    public static WxPayService getWxMpServiceFromThreadLocal() {
        return WX_PAY_SERVICE_THREAD_LOCAL.get();
    }

    public static void remove() {
        WX_PAY_SERVICE_THREAD_LOCAL.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WxPayService getWxPayServiceByAccount(AccountConfig accountConfig) {
        if (accountConfig == null) {
            return null;
        }
        String appId = accountConfig.getAppId();
        if (StringUtils.isBlank((String)appId)) {
            throw new NullPointerException("\u516c\u4f17\u53f7\u914d\u7f6e\u4e2d\uff0cappid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (wxPayServiceMap.get(appId) != null) {
            return wxPayServiceMap.get(appId);
        }
        Map<String, WxPayService> map = wxPayServiceMap;
        synchronized (map) {
            if (wxPayServiceMap.get(appId) == null) {
                WxPayServiceImpl service = new WxPayServiceImpl();
                service.setConfig(accountConfig.getWxPayConfig());
                wxPayServiceMap.put(appId, (WxPayService)service);
            }
        }
        return wxPayServiceMap.get(appId);
    }
}

