/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.msg.handler;

import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import com.els.base.wechat.msg.entity.WxMsgAutoReply;
import com.els.base.wechat.msg.entity.WxMsgAutoReplyExample;
import com.els.base.wechat.msg.entity.WxMsgReplyNews;
import com.els.base.wechat.msg.entity.WxMsgRule;
import com.els.base.wechat.msg.handler.BaseMsgHandler;
import com.els.base.wechat.msg.service.WxMsgAutoReplyService;
import com.els.base.wechat.msg.service.WxMsgReplyNewsService;
import com.els.base.wechat.qrcode.entity.WxQrcode;
import com.els.base.wechat.qrcode.service.WxQrcodeService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutNewsMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutTextMessage;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoReplyHandler
extends BaseMsgHandler {
    private static Logger logger = LoggerFactory.getLogger(AutoReplyHandler.class);

    public AutoReplyHandler(WxMsgRule wxMsgRule) {
        super(wxMsgRule);
    }

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService, WxSessionManager sessionManager) throws WxErrorException {
        logger.debug("com.els.base.wechat.msg.handler.AutoReplyHandler.handle => {}", (Object)wxMessage);
        String keywords = "";
        if ("text".equals(wxMessage.getMsgType())) {
            keywords = wxMessage.getContent();
        } else if ("event".equals(wxMessage.getMsgType())) {
            if ("subscribe".equals(wxMessage.getEvent()) || "SCAN".equals(wxMessage.getEvent())) {
                String qrcodeKey = wxMessage.getEventKey().replaceAll("qrscene_", "");
                WxQrcode qrcode = ((WxQrcodeService)SpringContextHolder.getOneBean(WxQrcodeService.class)).queryByKey(wxMessage.getToUser(), qrcodeKey);
                if (qrcode != null) {
                    keywords = qrcode.getReplyContent();
                }
            }
            if ("CLICK".equals(wxMessage.getEvent())) {
                keywords = wxMessage.getEventKey();
            }
        }
        if (StringUtils.isBlank((String)keywords)) {
            return this.reply(this.getDefaultAutoReply(wxMessage.getToUser()), wxMessage);
        }
        List<WxMsgAutoReply> list = this.getAutoReplyList(wxMessage.getToUser());
        for (int i = 0; CollectionUtils.isNotEmpty(list) && i < list.size(); ++i) {
            if (!this.isMatch(list.get(i), keywords)) continue;
            return this.reply(list.get(i), wxMessage);
        }
        return this.reply(this.getDefaultAutoReply(wxMessage.getToUser()), wxMessage);
    }

    private boolean isMatch(WxMsgAutoReply autoReply, String content) {
        String[] keywordsArray = autoReply.getKeywords().split("\\s*,\\s*");
        for (int i = 0; i < keywordsArray.length; ++i) {
            if (!(WxMsgRule.MATCH_TYPE_REGEX.toString().equals(autoReply.getMatchType()) ? content.contains(keywordsArray[i]) : content.trim().equals(keywordsArray[i]))) continue;
            return true;
        }
        return false;
    }

    private WxMpXmlOutMessage reply(WxMsgAutoReply autoReply, WxMpXmlMessage wxMessage) {
        if (autoReply == null) {
            return this.replyBlank(wxMessage);
        }
        if (WxMsgAutoReply.REPLY_TYPE_NEWS.equals(autoReply.getReplyType())) {
            return this.replyNews(autoReply.getReplyContent(), wxMessage);
        }
        return this.replyText(autoReply.getReplyContent(), wxMessage);
    }

    private WxMpXmlOutMessage replyBlank(WxMpXmlMessage wxMessage) {
        logger.warn("auto reply, reply blank msg, msg from user: " + wxMessage);
        WxMpXmlOutTextMessage outMessage = new WxMpXmlOutTextMessage();
        outMessage.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        outMessage.setFromUserName(wxMessage.getToUser());
        outMessage.setToUserName(wxMessage.getFromUser());
        return outMessage;
    }

    private WxMpXmlOutMessage replyText(String replyContent, WxMpXmlMessage wxMessage) {
        WxMpXmlOutTextMessage outMessage = new WxMpXmlOutTextMessage();
        outMessage.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        outMessage.setFromUserName(wxMessage.getToUser());
        outMessage.setToUserName(wxMessage.getFromUser());
        outMessage.setContent(replyContent);
        return outMessage;
    }

    private WxMpXmlOutMessage replyNews(String replyContent, WxMpXmlMessage wxMessage) {
        String[] ids = replyContent.split("\\s*,\\s*");
        ArrayList<WxMpXmlOutNewsMessage.Item> articleList = new ArrayList<WxMpXmlOutNewsMessage.Item>();
        for (int i = 0; i < ids.length; ++i) {
            WxMsgReplyNews msgNews = (WxMsgReplyNews)((WxMsgReplyNewsService)SpringContextHolder.getOneBean(WxMsgReplyNewsService.class)).queryObjById(Integer.valueOf(ids[i]));
            if (msgNews == null) continue;
            WxMpXmlOutNewsMessage.Item item = new WxMpXmlOutNewsMessage.Item();
            item.setTitle(msgNews.getTitle());
            item.setPicUrl(msgNews.getCoverImg());
            item.setDescription(msgNews.getSummary());
            item.setUrl(msgNews.getUrl());
            articleList.add(item);
        }
        WxMpXmlOutNewsMessage newsMsg = new WxMpXmlOutNewsMessage();
        newsMsg.setFromUserName(wxMessage.getToUser());
        newsMsg.setToUserName(wxMessage.getFromUser());
        newsMsg.setMsgType("news");
        newsMsg.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        for (int i = 0; CollectionUtils.isNotEmpty(articleList) && i < articleList.size(); ++i) {
            newsMsg.addArticle((WxMpXmlOutNewsMessage.Item)articleList.get(i));
        }
        return newsMsg;
    }

    private List<WxMsgAutoReply> getAutoReplyList(String originId) {
        WxMsgAutoReplyExample example = new WxMsgAutoReplyExample();
        example.createCriteria().andWxAccountOriginIdEqualTo(originId);
        example.setOrderByClause("priority DESC");
        List list = ((WxMsgAutoReplyService)SpringContextHolder.getOneBean(WxMsgAutoReplyService.class)).queryAllObjByExample((IExample)example);
        return list;
    }

    private WxMsgAutoReply getDefaultAutoReply(String originId) {
        WxMsgAutoReplyExample example = new WxMsgAutoReplyExample();
        example.createCriteria().andWxAccountOriginIdEqualTo(originId).andIsDefaultEqualTo(Constant.YES_INT);
        example.setOrderByClause("priority DESC");
        List list = ((WxMsgAutoReplyService)SpringContextHolder.getOneBean(WxMsgAutoReplyService.class)).queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (WxMsgAutoReply)list.get(0);
        }
        return null;
    }
}

