/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.msg.web.controller;

import com.els.base.core.exception.CommonException;
import com.els.base.utils.http.HttpRequestUtils;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.service.AccountConfigService;
import com.els.base.wechat.msg.service.WxMsgRuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5fae\u4fe1-\u516c\u4f17\u53f7\u540e\u53f0\u6d88\u606f\u5904\u7406")
@Controller
@RequestMapping(value={"wechatMsg"})
public class WechatMsgHandleController {
    protected static Logger logger = LoggerFactory.getLogger(WechatMsgHandleController.class);
    @Resource
    protected AccountConfigService accountConfigService;
    @Resource
    protected WxMsgRuleService wxMsgRuleService;

    @ApiOperation(httpMethod="POST", value="\u63a5\u6536\u5fae\u4fe1\u516c\u4f17\u53f7\u670d\u52a1\u5668\u53d1\u6765\u7684\u6d88\u606f")
    @RequestMapping(value={"front/{originId}"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String wechatApi(@PathVariable(value="originId") String originId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (StringUtils.isBlank((String)originId)) {
            logger.debug("originId is blank");
            return "wechatCode can not be null";
        }
        AccountConfig account = this.accountConfigService.queryByOriginId(originId);
        if (account == null) {
            throw new CommonException("\u672a\u5339\u914d\u5230\u5408\u9002\u7684\u516c\u4f17\u53f7\u914d\u7f6e");
        }
        String echostr = request.getParameter("echostr");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        if (StringUtils.isNotBlank((String)echostr)) {
            logger.debug("echostr => {}", (Object)echostr);
            return echostr;
        }
        String body = HttpRequestUtils.getRequestBody((HttpServletRequest)request);
        logger.debug("input msg:" + body);
        String encryptType = StringUtils.isBlank((String)request.getParameter("encrypt_type")) ? "raw" : request.getParameter("encrypt_type");
        String result = null;
        if ("raw".equals(encryptType)) {
            WxMpXmlMessage inMessage = WxMpXmlMessage.fromXml((String)body);
            WxMpXmlOutMessage outMessage = this.wxMsgRuleService.createRouter(account).route(inMessage);
            result = outMessage == null ? "" : outMessage.toXml();
        } else if ("aes".equals(encryptType)) {
            String msgSignature = request.getParameter("msg_signature");
            WxMpXmlMessage inMessage = WxMpXmlMessage.fromEncryptedXml((String)body, (WxMpConfigStorage)account.getWxMpConfigStorage(), (String)timestamp, (String)nonce, (String)msgSignature);
            WxMpXmlOutMessage outMessage = this.wxMsgRuleService.createRouter(account).route(inMessage);
            result = outMessage == null ? "" : outMessage.toEncryptedXml(account.getWxMpConfigStorage());
        } else {
            result = "\u4e0d\u53ef\u8bc6\u522b\u7684\u52a0\u5bc6\u7c7b\u578b";
        }
        logger.debug("result text => {}", (Object)result);
        return result;
    }
}

