/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.common;

import com.els.base.wechat.common.CustomMsgDeuplicateChecker;
import java.io.Serializable;
import me.chanjar.weixin.mp.api.WxMpMessageRouter;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;

public class CustomMessageRouter
extends WxMpMessageRouter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final CustomMsgDeuplicateChecker MESSAGE_DUPLICATE_CHECKER = new CustomMsgDeuplicateChecker();

    public CustomMessageRouter(WxMpService wxMpService) {
        super(wxMpService);
    }

    protected boolean isMsgDuplicated(WxMpXmlMessage wxMessage) {
        boolean isDuplicate = MESSAGE_DUPLICATE_CHECKER.isDuplicate(this.getMessageId(wxMessage));
        if (!isDuplicate) {
            MESSAGE_DUPLICATE_CHECKER.setMsgStatus(this.getMessageId(wxMessage), "processing");
        }
        return isDuplicate;
    }

    protected String getMessageId(WxMpXmlMessage wxMessage) {
        String messageId = "";
        messageId = wxMessage.getMsgId() == null ? String.valueOf(wxMessage.getCreateTime()) + "-" + wxMessage.getFromUser() + "-" + String.valueOf(wxMessage.getEventKey() == null ? "" : wxMessage.getEventKey()) + "-" + String.valueOf(wxMessage.getEvent() == null ? "" : wxMessage.getEvent()) : String.valueOf(wxMessage.getMsgId());
        return messageId;
    }

    public WxMpXmlOutMessage route(WxMpXmlMessage wxMessage) {
        WxMpXmlOutMessage outMsg = null;
        try {
            outMsg = super.route(wxMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
            MESSAGE_DUPLICATE_CHECKER.setMsgStatus(this.getMessageId(wxMessage), "error");
            throw e;
        }
        MESSAGE_DUPLICATE_CHECKER.setMsgStatus(this.getMessageId(wxMessage), "finish");
        return outMsg;
    }
}

