/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.msg;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.wechat.common.CustomMessageRouter;
import com.els.base.wechat.common.CustomMessageRouterRule;
import com.els.base.wechat.msg.McodingMsgMutilMatcher;
import com.els.base.wechat.msg.McodingMsgMutilRegexMatcher;
import com.els.base.wechat.msg.WxMpMessageSendTimeMatcher;
import com.els.base.wechat.msg.entity.WxMsgRule;
import com.els.base.wechat.msg.handler.AutoReplyHandler;
import com.els.base.wechat.msg.handler.BaseMsgHandler;
import com.els.base.wechat.msg.handler.DefaultSubscribeHandler;
import com.els.base.wechat.msg.handler.DefaultUnsubscribeHandler;
import com.els.base.wechat.msg.handler.ReplyTextHandler;
import com.els.base.wechat.msg.handler.ScanQrcodeHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import me.chanjar.weixin.mp.api.WxMpMessageRouter;
import me.chanjar.weixin.mp.api.WxMpService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpMessageRouterFactory {
    private static Logger logger = LoggerFactory.getLogger(WxMpMessageRouterFactory.class);
    public static final String HANDLER_SEPARATOR = "\\s*;\\s*";
    private static WxMsgRuleComparator wxMsgRuleComparator = new WxMsgRuleComparator();
    private static List<WxMsgRule> defaultMsgRuleList;

    private WxMpMessageRouterFactory() {
    }

    public static CustomMessageRouter build(List<WxMsgRule> ruleList, WxMpService wxMpService) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        CustomMessageRouter router = new CustomMessageRouter(wxMpService);
        if (CollectionUtils.isEmpty(ruleList)) {
            ruleList = new ArrayList<WxMsgRule>();
        }
        CollectionUtils.addAll(ruleList, WxMpMessageRouterFactory.getDefaultRuleList().iterator());
        Collections.sort(ruleList, wxMsgRuleComparator);
        for (int i = 0; i < ruleList.size(); ++i) {
            logger.debug("start setting rule:" + ruleList.get(i).getName());
            if (i < ruleList.size() - 1) {
                WxMpMessageRouterFactory.setRule(router, ruleList.get(i)).next();
                logger.debug("setting rule next:" + ruleList.get(i).getName());
            } else {
                WxMpMessageRouterFactory.setRule(router, ruleList.get(i)).end();
                logger.debug("setting rule end:" + ruleList.get(i).getName());
            }
            logger.debug("finish setting rule:" + ruleList.get(i).getName());
        }
        return router;
    }

    private static CustomMessageRouterRule setRule(WxMpMessageRouter router, WxMsgRule wxMsgRule) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        CustomMessageRouterRule routerRule = new CustomMessageRouterRule(router);
        if (StringUtils.isNotBlank((String)wxMsgRule.getFromUserName())) {
            routerRule.fromUser(wxMsgRule.getFromUserName());
        }
        if (StringUtils.isNotBlank((String)wxMsgRule.getMsgType())) {
            routerRule.msgType(wxMsgRule.getMsgType());
        }
        if (StringUtils.isNotBlank((String)wxMsgRule.getContent())) {
            if (wxMsgRule.getMatchType() != null && wxMsgRule.getMatchType().equals(WxMsgRule.MATCH_TYPE_REGEX)) {
                routerRule.matcher(new McodingMsgMutilRegexMatcher(wxMsgRule.getContent()));
            } else {
                routerRule.matcher(new McodingMsgMutilMatcher(wxMsgRule.getContent()));
            }
        }
        if (StringUtils.isNotBlank((String)wxMsgRule.getEvent())) {
            routerRule.event(wxMsgRule.getEvent());
        }
        if (StringUtils.isNotBlank((String)wxMsgRule.getEventKey())) {
            if (wxMsgRule.getMatchType() != null && wxMsgRule.getMatchType().equals(WxMsgRule.MATCH_TYPE_REGEX)) {
                routerRule.matcher(new McodingMsgMutilRegexMatcher(wxMsgRule.getEventKey()));
            } else {
                routerRule.matcher(new McodingMsgMutilMatcher(wxMsgRule.getEventKey()));
            }
        }
        if (wxMsgRule.getMsgStartTime() != null || wxMsgRule.getMsgEndTime() != null) {
            routerRule.matcher(new WxMpMessageSendTimeMatcher(wxMsgRule));
        }
        if (Constant.NO_INT.equals(wxMsgRule.getIsSycn())) {
            routerRule.async(true);
        } else {
            routerRule.async(false);
        }
        if (StringUtils.isBlank((String)wxMsgRule.getHandlers()) && StringUtils.isBlank((String)wxMsgRule.getReplyContent())) {
            throw new CommonException("\u8be5\u89c4\u5219\u65e0\u6548\uff0c\u56e0\u4e3a\u6ca1\u6709\u914d\u7f6e\u6587\u672c\uff0c\u4e5f\u6ca1\u6709\u914d\u7f6e\u5904\u7406\u5668");
        }
        if (StringUtils.isNotBlank((String)wxMsgRule.getReplyContent()) && StringUtils.isBlank((String)wxMsgRule.getHandlers())) {
            routerRule.handler(new ReplyTextHandler(wxMsgRule));
        } else {
            String[] handlers = wxMsgRule.getHandlers().split(HANDLER_SEPARATOR);
            for (int i = 0; i < handlers.length; ++i) {
                Class<?> handlerClass = Class.forName(handlers[i]);
                if (!BaseMsgHandler.class.isAssignableFrom(handlerClass)) {
                    throw new CommonException("\u8be5\u89c4\u5219\u65e0\u6548\uff0c\u56e0\u4e3a\u56e0\u4e3a\u914d\u7f6e\u7684\u5904\u7406\uff0c\u6ca1\u6709\u7ee7\u627fBaseMsgHandler");
                }
                Constructor<?> constructor = handlerClass.getConstructor(WxMsgRule.class);
                BaseMsgHandler handler = (BaseMsgHandler)constructor.newInstance(wxMsgRule);
                routerRule.handler(handler);
            }
        }
        return routerRule;
    }

    public static List<WxMsgRule> getDefaultRuleList() {
        if (defaultMsgRuleList != null) {
            return defaultMsgRuleList;
        }
        defaultMsgRuleList = new ArrayList<WxMsgRule>();
        WxMsgRule defaultSubscribeMsgRule = new WxMsgRule();
        defaultSubscribeMsgRule.setName("defaultSubcribeMsgRule");
        defaultSubscribeMsgRule.setMsgType("event");
        defaultSubscribeMsgRule.setEvent("subscribe");
        defaultSubscribeMsgRule.setIsSycn(Constant.NO_INT);
        defaultSubscribeMsgRule.setPriority(10);
        defaultSubscribeMsgRule.setHandlers(DefaultSubscribeHandler.class.getName());
        defaultMsgRuleList.add(defaultSubscribeMsgRule);
        WxMsgRule defaultUnsubscribeMsgRule = new WxMsgRule();
        defaultUnsubscribeMsgRule.setName("defaultUnsubcribeMsgRule");
        defaultUnsubscribeMsgRule.setMsgType("event");
        defaultUnsubscribeMsgRule.setEvent("unsubscribe");
        defaultUnsubscribeMsgRule.setIsSycn(Constant.NO_INT);
        defaultUnsubscribeMsgRule.setPriority(10);
        defaultUnsubscribeMsgRule.setHandlers(DefaultUnsubscribeHandler.class.getName());
        defaultMsgRuleList.add(defaultUnsubscribeMsgRule);
        WxMsgRule defaultScanQrcodeMsgRule = new WxMsgRule();
        defaultScanQrcodeMsgRule.setName("defaultScanQrcodeMsgRule");
        defaultScanQrcodeMsgRule.setMsgType("event");
        defaultScanQrcodeMsgRule.setIsSycn(Constant.NO_INT);
        defaultScanQrcodeMsgRule.setPriority(10);
        defaultScanQrcodeMsgRule.setHandlers(ScanQrcodeHandler.class.getName());
        defaultMsgRuleList.add(defaultScanQrcodeMsgRule);
        WxMsgRule defaultTextMsgRule = new WxMsgRule();
        defaultTextMsgRule.setName("defaultTextMsgRule");
        defaultTextMsgRule.setPriority(-1);
        defaultTextMsgRule.setHandlers(AutoReplyHandler.class.getName());
        defaultMsgRuleList.add(defaultTextMsgRule);
        return defaultMsgRuleList;
    }

    protected static class WxMsgRuleComparator
    implements Comparator<WxMsgRule> {
        protected WxMsgRuleComparator() {
        }

        @Override
        public int compare(WxMsgRule o1, WxMsgRule o2) {
            int result;
            if (o1.getIsSycn() == null) {
                o1.setIsSycn(Constant.YES_INT);
            }
            if (o2.getIsSycn() == null) {
                o2.setIsSycn(Constant.YES_INT);
            }
            if ((result = o1.getIsSycn().compareTo(o2.getIsSycn())) != 0) {
                return result;
            }
            if (o1.getPriority() == null) {
                o1.setPriority(0);
            }
            if (o2.getPriority() == null) {
                o2.setPriority(0);
            }
            return o1.getPriority().compareTo(o2.getPriority()) * -1;
        }
    }
}

