/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.redpack;

import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.common.WxPayServiceUtils;
import com.els.base.wechat.redpack.WxRedpackSentEvent;
import com.els.base.wechat.redpack.entity.WxRedpack;
import com.els.base.wechat.redpack.entity.WxRedpackExample;
import com.els.base.wechat.redpack.service.WxRedpackService;
import com.github.binarywang.wxpay.bean.request.WxPaySendRedpackRequest;
import com.github.binarywang.wxpay.bean.result.WxPaySendRedpackResult;
import com.github.binarywang.wxpay.service.WxPayService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.RandomUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationEvent;

public class RedpackSender {
    private static WxRedpackService wxRedpackService = (WxRedpackService)SpringContextHolder.getOneBean(WxRedpackService.class);

    public static void sendNormalRedpack(String redpackCode, String reopenid, String billNo, AccountConfig accountConfig) throws IllegalArgumentException, IllegalAccessException, UnknownHostException, WxErrorException {
        WxRedpackExample example = new WxRedpackExample();
        example.createCriteria().andRedpackCodeEqualTo(redpackCode).andIsEnableEqualTo(Constant.YES_INT);
        List list = wxRedpackService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new NullPointerException("\u6ca1\u6709\u627e\u5230code[" + redpackCode + "] \u7684\u7ea2\u5305");
        }
        RedpackSender.sendNormalRedpack((WxRedpack)list.get(0), reopenid, billNo, accountConfig);
    }

    public static WxPaySendRedpackResult sendNormalRedpack(WxRedpack redpack, String reopenid, String billNo, AccountConfig accountConfig) throws IllegalArgumentException, IllegalAccessException, UnknownHostException, WxErrorException {
        if (StringUtils.isBlank((String)accountConfig.getCertPath())) {
            throw new IllegalArgumentException("\u516c\u4f17\u53f7\u914d\u7f6e\u4e2d\uff0c\u7f3a\u4e4f\u652f\u4ed8\u8bc1\u4e66\u7684\u914d\u7f6e");
        }
        if (StringUtils.isBlank((String)redpack.getWishing()) || StringUtils.isBlank((String)redpack.getActName()) || StringUtils.isBlank((String)redpack.getRemark())) {
            throw new NullPointerException("\u7ea2\u5305\u914d\u7f6e\u4e2d\uff0c\u914d\u7f6e\u4e0d\u5168\uff0c\u8bf7\u68c0\u67e5\u795d\u798f\u8bed\u3001\u6d3b\u52a8\u540d\u3001\u6216\u5907\u6ce8");
        }
        if (redpack.getQuotaLimitUp() == null || redpack.getQuotaLimitUp() <= 0) {
            throw new NullPointerException("\u7ea2\u5305\u914d\u7f6e\u4e2d\uff0c\u989d\u5ea6\u7684\u4e0a\u9650\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer amountTotal = 0;
        if (Constant.YES_INT.equals(redpack.getIsRandom()) && redpack.getQuotaLimitDown() == null) {
            redpack.setQuotaLimitDown(0);
            amountTotal = (int)((double)redpack.getQuotaLimitDown().intValue() + (double)(redpack.getQuotaLimitUp() - redpack.getQuotaLimitDown()) * Math.random());
        } else {
            amountTotal = redpack.getQuotaLimitUp();
        }
        WxPaySendRedpackRequest outMessage = new WxPaySendRedpackRequest();
        outMessage.setNonceStr(RandomUtils.getRandomStr());
        outMessage.setMchId(accountConfig.getMchId());
        outMessage.setAppid(accountConfig.getAppId());
        outMessage.setTotalNum(Integer.valueOf(1));
        outMessage.setClientIp(InetAddress.getLocalHost().getHostAddress());
        outMessage.setMchBillNo(accountConfig.getMchId() + billNo);
        outMessage.setSendName(StringUtils.defaultIfBlank((String)redpack.getSendName(), (String)accountConfig.getName()));
        outMessage.setReOpenid(reopenid);
        outMessage.setWishing(redpack.getWishing());
        outMessage.setActName(redpack.getActName());
        outMessage.setRemark(redpack.getRemark());
        outMessage.setSceneId(redpack.getSceneId());
        outMessage.setTotalAmount(amountTotal);
        return RedpackSender.sendNormalRedpack(outMessage, accountConfig);
    }

    public static WxPaySendRedpackResult sendNormalRedpack(WxPaySendRedpackRequest outMessage, AccountConfig accountConfig) throws WxErrorException {
        WxPaySendRedpackResult result = null;
        WxRedpackSentEvent event = new WxRedpackSentEvent("");
        event.setOutMessage(outMessage);
        event.setAccountConfig(accountConfig);
        try {
            WxPayService service = WxPayServiceUtils.getWxPayServiceByAccount(accountConfig);
            result = service.sendRedpack(outMessage);
            event.setInMessage(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (result == null) {
                result = new WxPaySendRedpackResult();
                result.setReturnCode("FAIL");
                result.setResultCode("FAIL");
                result.setErrCode(e.getMessage());
            }
            event.setInMessage(result);
        }
        SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)event);
        if (!"SUCCESS".equals(result.getReturnCode()) || !"SUCCESS".equals(result.getResultCode())) {
            WxError error = new WxError();
            error.setErrorCode(-1);
            error.setErrorMsg("code:" + result.getReturnCode() + ",msg:" + result.getReturnMsg());
            throw new WxErrorException(error);
        }
        return result;
    }
}

