/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.common;

import com.els.base.utils.SpringContextHolder;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.utils.WechatTokenOrTicketManager;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import org.apache.commons.lang.StringUtils;

public class CustomWxMpConfigStorage
implements WxMpConfigStorage,
Serializable {
    private static final long serialVersionUID = 1L;
    protected volatile String oauth2redirectUri;
    protected volatile ApacheHttpClientBuilder apacheHttpClientBuilder;
    protected Lock accessTokenLock = new ReentrantLock();
    protected Lock jsapiTicketLock = new ReentrantLock();
    protected Lock cardApiTicketLock = new ReentrantLock();
    private AccountConfig accountConfig;

    public CustomWxMpConfigStorage(AccountConfig accountConfig) {
        this.accountConfig = accountConfig;
    }

    public AccountConfig getAccountConfig() {
        return this.accountConfig;
    }

    public String getAccessToken() {
        return WechatTokenOrTicketManager.getInstance().getAccessToken(this.accountConfig.getId());
    }

    public boolean isAccessTokenExpired() {
        return System.currentTimeMillis() > WechatTokenOrTicketManager.getInstance().getAccessTokenExpiresTime(this.accountConfig.getId());
    }

    public void expireAccessToken() {
        WechatTokenOrTicketManager.getInstance().expireAccessToken(this.accountConfig.getId());
    }

    public synchronized void updateAccessToken(WxAccessToken accessToken) {
        this.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
    }

    public synchronized void updateAccessToken(String accessToken, int expiresIn) {
        WechatTokenOrTicketManager.getInstance().updateAccessToken(this.accountConfig.getId(), accessToken, System.currentTimeMillis() + (long)(expiresIn - 200) * 1000L);
    }

    public String getJsapiTicket() {
        return WechatTokenOrTicketManager.getInstance().getJsapiTicket(this.accountConfig.getId());
    }

    public boolean isJsapiTicketExpired() {
        return System.currentTimeMillis() > WechatTokenOrTicketManager.getInstance().getJsapiTicketExpiresTime(this.accountConfig.getId());
    }

    public void expireJsapiTicket() {
        WechatTokenOrTicketManager.getInstance().expireJsapiTicket(this.accountConfig.getId());
    }

    public void updateJsapiTicket(String jsapiTicket, int expiresInSeconds) {
        WechatTokenOrTicketManager.getInstance().updateJsapiTicket(this.accountConfig.getId(), jsapiTicket, System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L);
    }

    public String getCardApiTicket() {
        return WechatTokenOrTicketManager.getInstance().getCardApiTicket(this.accountConfig.getId());
    }

    public boolean isCardApiTicketExpired() {
        return System.currentTimeMillis() > WechatTokenOrTicketManager.getInstance().getCardApiTicketExpiresTime(this.accountConfig.getId());
    }

    public void expireCardApiTicket() {
        WechatTokenOrTicketManager.getInstance().expireCardApiTicket(this.accountConfig.getId());
    }

    public void updateCardApiTicket(String cardApiTicket, int expiresInSeconds) {
        WechatTokenOrTicketManager.getInstance().updateCardApiTicket(this.accountConfig.getId(), cardApiTicket, System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L);
    }

    public String getSecret() {
        return this.accountConfig.getAppSecret();
    }

    public String getPartnerId() {
        return this.accountConfig.getMchId();
    }

    public String getPartnerKey() {
        return this.accountConfig.getMchKey();
    }

    public long getExpiresTime() {
        return WechatTokenOrTicketManager.getInstance().getAccessTokenExpiresTime(this.accountConfig.getId());
    }

    public String getOauth2redirectUri() {
        return this.oauth2redirectUri;
    }

    public File getTmpDirFile() {
        String filePath = SpringContextHolder.getProperty((String)"resource.location");
        if (StringUtils.isNotBlank((String)filePath)) {
            return new File(filePath);
        }
        return null;
    }

    public Lock getAccessTokenLock() {
        return this.accessTokenLock;
    }

    public Lock getJsapiTicketLock() {
        return this.jsapiTicketLock;
    }

    public Lock getCardApiTicketLock() {
        return this.cardApiTicketLock;
    }

    public String getHttpProxyHost() {
        return null;
    }

    public int getHttpProxyPort() {
        return 0;
    }

    public String getHttpProxyUsername() {
        return null;
    }

    public String getHttpProxyPassword() {
        return null;
    }

    public ApacheHttpClientBuilder getApacheHttpClientBuilder() {
        return this.apacheHttpClientBuilder;
    }

    public boolean autoRefreshToken() {
        return true;
    }

    public String getAppId() {
        return this.accountConfig.getAppId();
    }

    public String getToken() {
        return this.accountConfig.getToken();
    }

    public String getAesKey() {
        return this.accountConfig.getAesKey();
    }
}

