/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.msg.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.wechat.account.utils.WxAccountConfigUtils;
import com.els.base.wechat.msg.entity.WxTemplateMessage;
import com.els.base.wechat.msg.entity.WxTemplateMessageExample;
import com.els.base.wechat.msg.service.WxTemplateMessageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u5fae\u4fe1-\u516c\u4f17\u53f7\u6a21\u677f\u6d88\u606f"})
@Controller
@RequestMapping(value={"wxTemplateMessage"})
public class WxTemplateMessageController {
    @Resource
    protected WxTemplateMessageService wxTemplateMessageService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u516c\u4f17\u53f7\u6a21\u677f\u6d88\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody WxTemplateMessage wxTemplateMessage) {
        if (StringUtils.isBlank((String)wxTemplateMessage.getWxAccountId())) {
            wxTemplateMessage.setWxAccountId(WxAccountConfigUtils.getDefaultAccountFromConfig().getId());
        }
        this.wxTemplateMessageService.addObj(wxTemplateMessage);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u516c\u4f17\u53f7\u6a21\u677f\u6d88\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody WxTemplateMessage wxTemplateMessage) {
        if (StringUtils.isBlank((String)wxTemplateMessage.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.wxTemplateMessageService.modifyObj(wxTemplateMessage);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u516c\u4f17\u53f7\u6a21\u677f\u6d88\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.wxTemplateMessageService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u516c\u4f17\u53f7\u6a21\u677f\u6d88\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 WxTemplateMessage", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<WxTemplateMessage>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        WxTemplateMessageExample example = new WxTemplateMessageExample();
        example.setPageView((PageView<WxTemplateMessage>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            WxTemplateMessageExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.wxTemplateMessageService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

