package com.els.base.wechat.common;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import org.apache.commons.lang.StringUtils;

import com.els.base.utils.SpringContextHolder;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.utils.WechatTokenOrTicketManager;

import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;

public class CustomWxMpConfigStorage implements WxMpConfigStorage, Serializable{

	private static final long serialVersionUID = 1L;
	
	protected volatile String oauth2redirectUri;
	protected volatile ApacheHttpClientBuilder apacheHttpClientBuilder;
	protected Lock accessTokenLock = new ReentrantLock();
	protected Lock jsapiTicketLock = new ReentrantLock();
	protected Lock cardApiTicketLock = new ReentrantLock();
	
	private AccountConfig accountConfig;
	
	public CustomWxMpConfigStorage(AccountConfig accountConfig) {
		super();
		this.accountConfig = accountConfig;
	}

	public AccountConfig getAccountConfig() {
		return accountConfig;
	}

	@Override
	public String getAccessToken() {
		return WechatTokenOrTicketManager.getInstance().getAccessToken(this.accountConfig.getId());
	}

	@Override
	public boolean isAccessTokenExpired() {
	    return System.currentTimeMillis() > WechatTokenOrTicketManager.getInstance().getAccessTokenExpiresTime(this.accountConfig.getId());
	}

	@Override
	public void expireAccessToken() {
		WechatTokenOrTicketManager.getInstance().expireAccessToken(this.accountConfig.getId());
	}

	@Override
	public synchronized void updateAccessToken(WxAccessToken accessToken) {
	    updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
	}

	@Override
	public synchronized void updateAccessToken(String accessToken, int expiresIn) {
		WechatTokenOrTicketManager.getInstance().updateAccessToken(this.accountConfig.getId(), accessToken, System.currentTimeMillis() + (expiresIn - 200) * 1000l);
	}

	@Override
	public String getJsapiTicket() {
		return WechatTokenOrTicketManager.getInstance().getJsapiTicket(this.accountConfig.getId());
	}

	@Override
	public boolean isJsapiTicketExpired() {
	    return System.currentTimeMillis() > WechatTokenOrTicketManager.getInstance().getJsapiTicketExpiresTime(this.accountConfig.getId());
	}

	@Override
	public void expireJsapiTicket() {
		WechatTokenOrTicketManager.getInstance().expireJsapiTicket(this.accountConfig.getId());;
	}

	@Override
	public void updateJsapiTicket(String jsapiTicket, int expiresInSeconds) {
		WechatTokenOrTicketManager.getInstance().updateJsapiTicket(this.accountConfig.getId(), jsapiTicket, System.currentTimeMillis() + (expiresInSeconds - 200) * 1000l);
	}
	
	public String getCardApiTicket(){
		return WechatTokenOrTicketManager.getInstance().getCardApiTicket(this.accountConfig.getId());
	}
	
	public boolean isCardApiTicketExpired(){
		return System.currentTimeMillis() > WechatTokenOrTicketManager.getInstance().getCardApiTicketExpiresTime(this.accountConfig.getId());
	}
	
	public void expireCardApiTicket(){
		WechatTokenOrTicketManager.getInstance().expireCardApiTicket(this.accountConfig.getId());
	}
	
	public void updateCardApiTicket(String cardApiTicket, int expiresInSeconds){
		WechatTokenOrTicketManager.getInstance().updateCardApiTicket(this.accountConfig.getId(), cardApiTicket, System.currentTimeMillis() + (expiresInSeconds - 200) * 1000l);
	}

	@Override
	public String getSecret() {
		return this.accountConfig.getAppSecret();
	}

	public String getPartnerId() {
		return this.accountConfig.getMchId();
	}

	public String getPartnerKey() {
		return this.accountConfig.getMchKey();
	}

	@Override
	public long getExpiresTime() {
		return WechatTokenOrTicketManager.getInstance().getAccessTokenExpiresTime(this.accountConfig.getId());
	}

	@Override
	public String getOauth2redirectUri() {
		return this.oauth2redirectUri;
	}

	@Override
	public File getTmpDirFile() {
		Properties properties = SpringContextHolder.getBean("sysConfig");
		String filePath = properties.getProperty("resource.location");
		if(StringUtils.isNotBlank(filePath)){
			return new File(filePath);
		}else{
			return null;
		}
	}

	@Override
	public Lock getAccessTokenLock() {
		return this.accessTokenLock;
	}

	@Override
	public Lock getJsapiTicketLock() {
		return this.jsapiTicketLock;
	}

	@Override
	public Lock getCardApiTicketLock() {
		return this.cardApiTicketLock;
	}

	@Override
	public String getHttpProxyHost() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public int getHttpProxyPort() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public String getHttpProxyUsername() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getHttpProxyPassword() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ApacheHttpClientBuilder getApacheHttpClientBuilder() {
		return this.apacheHttpClientBuilder;
	}

	@Override
	public boolean autoRefreshToken() {
		return true;
	}

	@Override
	public String getAppId() {
		return this.accountConfig.getAppId();
	}

	@Override
	public String getToken() {
		return this.accountConfig.getToken();
	}

	@Override
	public String getAesKey() {
		return this.accountConfig.getAesKey();
	}
	
	/*@Override
	public SSLContext getSslContext() {
		if (this.sslContext != null) {
			return this.sslContext;
		}
		
		if (StringUtils.isBlank(this.getPartnerId()) || StringUtils.isBlank(this.certPath)) {
			return null;
		}
	
		File file = new File(this.certPath);
	    if (!file.exists()) {
	        throw new RuntimeException("证书文件：【" + file.getPath() + "】不存在！");
	    }

	    try {
	        FileInputStream inputStream = new FileInputStream(file);
	        KeyStore keystore = KeyStore.getInstance("PKCS12");
	        char[] partnerId2charArray = this.getPartnerId().toCharArray();
	        keystore.load(inputStream, partnerId2charArray);
	        this.sslContext = SSLContexts.custom().loadKeyMaterial(keystore, partnerId2charArray).build();
	    } catch (Exception e) {
	      throw new RuntimeException("证书文件有问题，请核实！", e);
	    }
		    
		return this.sslContext;
	}*/

}
