package com.els.base.wechat.msg.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.wechat.msg.dao.WxTemplateMessageMapper;
import com.els.base.wechat.msg.entity.WxTemplateMessage;
import com.els.base.wechat.msg.entity.WxTemplateMessageExample;
import com.els.base.wechat.msg.service.WxTemplateMessageService;

@Service("wxTemplateMessageService")
public class WxTemplateMessageServiceImpl implements WxTemplateMessageService {
    @Resource
    protected WxTemplateMessageMapper wxTemplateMessageMapper;

    @CacheEvict(value={"wxTemplateMessage"}, allEntries=true)
    @Override
    public void addObj(WxTemplateMessage t) {
    	if (StringUtils.isBlank(t.getType())) {
			throw new CommonException("业务类型不存在","do_not_exists", "业务类型");
		}
    	if (StringUtils.isBlank(t.getWxAccountId())) {
    		throw new CommonException("公众号id不存在","do_not_exists", "公众号id");
    	}
    	if (StringUtils.isBlank(t.getTemplateId())) {
    		throw new CommonException("公众号的模板id不能为空","do_not_exists", "公众号的模板id");
    	}
    	
    	WxTemplateMessageExample example = new WxTemplateMessageExample();
    	example.createCriteria()
    	       .andWxAccountIdEqualTo(t.getWxAccountId())
    	       .andTypeEqualTo(t.getType());
    	
    	if (this.wxTemplateMessageMapper.countByExample(example) > 0) {
    		throw new CommonException("公众号上已经存在该业务的模板消息","base_is_exists", "公众号上该业务的模板消息");
		}
    	
        this.wxTemplateMessageMapper.insertSelective(t);
    }

    @CacheEvict(value={"wxTemplateMessage"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.wxTemplateMessageMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"wxTemplateMessage"}, allEntries=true)
    @Override
    public void modifyObj(WxTemplateMessage t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new CommonException("id 为空，无法更新","id_is_blank");
        }
        if (StringUtils.isBlank(t.getType())) {
			throw new CommonException("业务类型不存在","do_not_exists", "业务类型");
		}
    	if (StringUtils.isBlank(t.getWxAccountId())) {
    		throw new CommonException("公众号id不存在","do_not_exists", "公众号id");
    	}
    	
    	WxTemplateMessageExample example = new WxTemplateMessageExample();
    	example.createCriteria()
    	       .andWxAccountIdEqualTo(t.getWxAccountId())
    	       .andTypeEqualTo(t.getType())
    	       .andIdNotEqualTo(t.getId());
    	
    	if (this.wxTemplateMessageMapper.countByExample(example) > 0) {
    		throw new CommonException("公众号上已经存在该业务的模板消息","base_is_exists", "公众号上该业务的模板消息");
		}
        this.wxTemplateMessageMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="wxTemplateMessage", keyGenerator="redisKeyGenerator")
    @Override
    public WxTemplateMessage queryObjById(String id) {
        return this.wxTemplateMessageMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="wxTemplateMessage", keyGenerator="redisKeyGenerator")
    @Override
    public List<WxTemplateMessage> queryAllObjByExample(WxTemplateMessageExample example) {
        return this.wxTemplateMessageMapper.selectByExample(example);
    }

    @Cacheable(value="wxTemplateMessage", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<WxTemplateMessage> queryObjByPage(WxTemplateMessageExample example) {
        PageView<WxTemplateMessage> pageView = example.getPageView();
        if (pageView == null) {
            pageView = new PageView<>(1, 10);
            example.setPageView(pageView);
        }
        pageView.setQueryResult(this.wxTemplateMessageMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Cacheable(value="wxTemplateMessage", keyGenerator="redisKeyGenerator")
	@Override
	public WxTemplateMessage queryByAccountAndType(String accountId, String type) {
		WxTemplateMessageExample example = new WxTemplateMessageExample();
		example.createCriteria().andWxAccountIdEqualTo(accountId).andTypeEqualTo(type);
		
		List<WxTemplateMessage> list = this.wxTemplateMessageMapper.selectByExample(example);
		if (CollectionUtils.isEmpty(list)) {
			return null;
		}
		
		return list.get(0);
	}
}