CREATE TABLE  "T_BASE_MAIL" (
"ID" VARCHAR2(255) NOT NULL ,
"USER_ID" VARCHAR2(32) NULL ,
"c" VARCHAR2(255) NULL ,
"CREATE_TIME" DATE DEFAULT sysdate  NULL ,
"PROJECT_ID" VARCHAR2(32) NULL ,
"COMPANY_ID" VARCHAR2(32) NULL ,
"STMP_SERVER_HOST" VARCHAR2(255) NULL ,
"STMP_SERVER_PORT" VARCHAR2(255) NULL ,
"STMP_SERVER_IS_SSL" NUMBER(1) NULL ,
"MAIL_ADDRESS" VARCHAR2(255) NULL ,
"PASSWORD" VARCHAR2(255) NULL ,
"REMARK" VARCHAR2(255) NULL ,
"RECEIVE_SERVER_HOST" VARCHAR2(255) NULL ,
"RECEIVE_SERVER_PORT" VARCHAR2(255) NULL ,
"RECEIVE_SERVER_IS_SSL" NUMBER(1) NULL ,
"RECEIVE_SERVER_PROTOCOL" NUMBER(1) NULL ,
"COMPANY_NAME" VARCHAR2(255) NULL ,
"USER_NAME" VARCHAR2(255) NULL ,
PRIMARY KEY ("ID")
)
NOCOMPRESS
;
COMMENT ON TABLE  "T_BASE_MAIL" IS '邮件端口信息';

COMMENT ON COLUMN  "T_BASE_MAIL"."ID" IS 'ID';

COMMENT ON COLUMN  "T_BASE_MAIL"."USER_ID" IS '邮箱的拥有者';

COMMENT ON COLUMN  "T_BASE_MAIL"."CREATE_USER" IS '创建人';

COMMENT ON COLUMN  "T_BASE_MAIL"."CREATE_TIME" IS '创建日期';

COMMENT ON COLUMN  "T_BASE_MAIL"."PROJECT_ID" IS '项目id';

COMMENT ON COLUMN  "T_BASE_MAIL"."COMPANY_ID" IS 'companyId';

COMMENT ON COLUMN  "T_BASE_MAIL"."STMP_SERVER_HOST" IS '发邮件服务器地址';

COMMENT ON COLUMN  "T_BASE_MAIL"."STMP_SERVER_PORT" IS '发邮件服务器端口';

COMMENT ON COLUMN  "T_BASE_MAIL"."STMP_SERVER_IS_SSL" IS '发邮件服务器地址，是否ssl';

COMMENT ON COLUMN  "T_BASE_MAIL"."MAIL_ADDRESS" IS '邮箱地址';

COMMENT ON COLUMN  "T_BASE_MAIL"."PASSWORD" IS '密码';

COMMENT ON COLUMN  "T_BASE_MAIL"."REMARK" IS '备注说明';

COMMENT ON COLUMN  "T_BASE_MAIL"."RECEIVE_SERVER_HOST" IS '接收服务器地址';

COMMENT ON COLUMN  "T_BASE_MAIL"."RECEIVE_SERVER_PORT" IS '接收服务器端口';

COMMENT ON COLUMN  "T_BASE_MAIL"."RECEIVE_SERVER_IS_SSL" IS '是否选择ssl';

COMMENT ON COLUMN  "T_BASE_MAIL"."RECEIVE_SERVER_PROTOCOL" IS '收件协议，1 pop3,2 imap';

COMMENT ON COLUMN  "T_BASE_MAIL"."COMPANY_NAME" IS '公司名称';

COMMENT ON COLUMN  "T_BASE_MAIL"."USER_NAME" IS '用户名称';



CREATE TABLE  "T_BASE_MAIL_TEMPLATE" (
"ID" VARCHAR2(32) NOT NULL ,
"PROJECT_ID" VARCHAR2(32) NULL ,
"COMPANY_ID" VARCHAR2(32) NULL ,
"TEMPLATE_NUM" VARCHAR2(255) NULL ,
"TEMPLATE_NAME" VARCHAR2(255) NULL ,
"LANGUAGE" VARCHAR2(255) NULL ,
"CREATE_USER" VARCHAR2(255) NULL ,
"CREATE_DATE" DATE DEFAULT sysdate  NULL ,
"MODIFY_DATE" DATE DEFAULT sysdate  NULL ,
PRIMARY KEY ("ID")
)
NOCOMPRESS
;

ALTER TABLE "T_BASE_MAIL_TEMPLATE"
ADD ( "TEMPLATE_CONTENT" CLOB NULL  ) ;

COMMENT ON TABLE  "T_BASE_MAIL_TEMPLATE" IS '邮件模板信息';

COMMENT ON COLUMN  "T_BASE_MAIL_TEMPLATE"."PROJECT_ID" IS '项目id';

COMMENT ON COLUMN  "T_BASE_MAIL_TEMPLATE"."COMPANY_ID" IS 'companyId';

COMMENT ON COLUMN  "T_BASE_MAIL_TEMPLATE"."TEMPLATE_NUM" IS '邮件模板号';

COMMENT ON COLUMN  "T_BASE_MAIL_TEMPLATE"."LANGUAGE" IS '语言';

COMMENT ON COLUMN  "T_BASE_MAIL_TEMPLATE"."TEMPLATE_NAME" IS '模板名称';

COMMENT ON COLUMN  "T_BASE_MAIL_TEMPLATE"."CREATE_USER" IS '创建人';

COMMENT ON COLUMN  "T_BASE_MAIL_TEMPLATE"."CREATE_DATE" IS '创建日期';

COMMENT ON COLUMN  "T_BASE_MAIL_TEMPLATE"."MODIFY_DATE" IS '修改日期';

COMMENT ON COLUMN  "T_BASE_MAIL_TEMPLATE"."TEMPLATE_CONTENT" IS '模板内容';


