/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.msg.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.wechat.msg.dao.WxTemplateMessageMapper;
import com.els.base.wechat.msg.entity.WxTemplateMessage;
import com.els.base.wechat.msg.entity.WxTemplateMessageExample;
import com.els.base.wechat.msg.service.WxTemplateMessageService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="wxTemplateMessageService")
public class WxTemplateMessageServiceImpl
implements WxTemplateMessageService {
    @Resource
    protected WxTemplateMessageMapper wxTemplateMessageMapper;

    @CacheEvict(value={"wxTemplateMessage"}, allEntries=true)
    public void addObj(WxTemplateMessage t) {
        if (StringUtils.isBlank((String)t.getType())) {
            throw new CommonException("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728", "do_not_exists", new Object[]{"\u4e1a\u52a1\u7c7b\u578b"});
        }
        if (StringUtils.isBlank((String)t.getWxAccountId())) {
            throw new CommonException("\u516c\u4f17\u53f7id\u4e0d\u5b58\u5728", "do_not_exists", new Object[]{"\u516c\u4f17\u53f7id"});
        }
        if (StringUtils.isBlank((String)t.getTemplateId())) {
            throw new CommonException("\u516c\u4f17\u53f7\u7684\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a", "do_not_exists", new Object[]{"\u516c\u4f17\u53f7\u7684\u6a21\u677fid"});
        }
        WxTemplateMessageExample example = new WxTemplateMessageExample();
        example.createCriteria().andWxAccountIdEqualTo(t.getWxAccountId()).andTypeEqualTo(t.getType());
        if (this.wxTemplateMessageMapper.countByExample(example) > 0) {
            throw new CommonException("\u516c\u4f17\u53f7\u4e0a\u5df2\u7ecf\u5b58\u5728\u8be5\u4e1a\u52a1\u7684\u6a21\u677f\u6d88\u606f", "base_is_exists", new Object[]{"\u516c\u4f17\u53f7\u4e0a\u8be5\u4e1a\u52a1\u7684\u6a21\u677f\u6d88\u606f"});
        }
        this.wxTemplateMessageMapper.insertSelective(t);
    }

    @CacheEvict(value={"wxTemplateMessage"}, allEntries=true)
    public void deleteObjById(String id) {
        this.wxTemplateMessageMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"wxTemplateMessage"}, allEntries=true)
    public void modifyObj(WxTemplateMessage t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0", "id_is_blank");
        }
        if (StringUtils.isBlank((String)t.getType())) {
            throw new CommonException("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728", "do_not_exists", new Object[]{"\u4e1a\u52a1\u7c7b\u578b"});
        }
        if (StringUtils.isBlank((String)t.getWxAccountId())) {
            throw new CommonException("\u516c\u4f17\u53f7id\u4e0d\u5b58\u5728", "do_not_exists", new Object[]{"\u516c\u4f17\u53f7id"});
        }
        WxTemplateMessageExample example = new WxTemplateMessageExample();
        example.createCriteria().andWxAccountIdEqualTo(t.getWxAccountId()).andTypeEqualTo(t.getType()).andIdNotEqualTo(t.getId());
        if (this.wxTemplateMessageMapper.countByExample(example) > 0) {
            throw new CommonException("\u516c\u4f17\u53f7\u4e0a\u5df2\u7ecf\u5b58\u5728\u8be5\u4e1a\u52a1\u7684\u6a21\u677f\u6d88\u606f", "base_is_exists", new Object[]{"\u516c\u4f17\u53f7\u4e0a\u8be5\u4e1a\u52a1\u7684\u6a21\u677f\u6d88\u606f"});
        }
        this.wxTemplateMessageMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"wxTemplateMessage"}, keyGenerator="redisKeyGenerator")
    public WxTemplateMessage queryObjById(String id) {
        return this.wxTemplateMessageMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"wxTemplateMessage"}, keyGenerator="redisKeyGenerator")
    public List<WxTemplateMessage> queryAllObjByExample(WxTemplateMessageExample example) {
        return this.wxTemplateMessageMapper.selectByExample(example);
    }

    @Cacheable(value={"wxTemplateMessage"}, keyGenerator="redisKeyGenerator")
    public PageView<WxTemplateMessage> queryObjByPage(WxTemplateMessageExample example) {
        PageView pageView = example.getPageView();
        if (pageView == null) {
            pageView = new PageView(1, 10);
            example.setPageView((PageView<WxTemplateMessage>)pageView);
        }
        pageView.setQueryResult(this.wxTemplateMessageMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"wxTemplateMessage"}, keyGenerator="redisKeyGenerator")
    public WxTemplateMessage queryByAccountAndType(String accountId, String type) {
        WxTemplateMessageExample example = new WxTemplateMessageExample();
        example.createCriteria().andWxAccountIdEqualTo(accountId).andTypeEqualTo(type);
        List<WxTemplateMessage> list = this.wxTemplateMessageMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }
}

