/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.oauth.web.controller;

import com.els.base.core.entity.ResponseResult;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.service.AccountConfigService;
import com.els.base.wechat.account.utils.WxAccountConfigUtils;
import com.els.base.wechat.common.WxMpServiceUtils;
import com.els.base.wechat.oauth.service.WechatOauthService;
import com.els.base.wechat.oauth.utils.WechatOauthUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.ModelAndView;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u5fae\u4fe1-\u516c\u4f17\u53f7\u7f51\u9875\u6388\u6743\u63a5\u53e3")
@Controller
public class WechatOauthController {
    private static Logger logger = LoggerFactory.getLogger(WechatOauthController.class);
    private static final Pattern urlPatther = Pattern.compile("((http|https):\\/\\/.+)?\\?(.+)");
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static String defaultPage;
    @Autowired
    protected AccountConfigService accountConfigService;

    @ApiIgnore
    @RequestMapping(value={"/wechatOauth/front/oauth2Openid/{params}"})
    public ModelAndView receiveOpenid(@PathVariable(value="params") String params, String code, HttpServletRequest request, HttpServletResponse response) throws WxErrorException {
        logger.debug("receive wechat post code :" + code + ", with params :" + params);
        Map<String, String> paramsMap = null;
        String targetUrl = null;
        try {
            paramsMap = this.getParamsMapFromState(params);
            if (paramsMap != null) {
                targetUrl = paramsMap.get("TU");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AccountConfig accountConfig = this.accountConfigService.queryByOriginId(paramsMap.get("APPID"));
        WxMpService wxMpService = WxMpServiceUtils.getWxMpServiceByAccount(accountConfig);
        logger.debug("wxMpService:" + wxMpService + ",account:" + accountConfig);
        WxMpOAuth2AccessToken wxMpOAuth2AccessToken = wxMpService.oauth2getAccessToken(code);
        String openId = wxMpOAuth2AccessToken.getOpenId();
        String serverName = StringUtils.substringBefore((String)StringUtils.substringBetween((String)targetUrl, (String)"://", (String)"/"), (String)":");
        if (StringUtils.isBlank((String)targetUrl)) {
            targetUrl = serverName + defaultPage;
        }
        logger.debug("after oauth redirect to :" + targetUrl);
        this.handleWithOpenidAndParamsMap(openId, paramsMap, request, response);
        request.getSession().setAttribute("openid", (Object)openId);
        request.setAttribute("openid", (Object)openId);
        String redirectTargetUrl = (String)request.getAttribute("redirectTargetUrl");
        if (StringUtils.isNotBlank((String)redirectTargetUrl)) {
            targetUrl = redirectTargetUrl;
        }
        String viewName = "redirect:" + targetUrl;
        paramsMap.put("openid", openId);
        ModelAndView modelAndView = new ModelAndView(viewName, paramsMap);
        return modelAndView;
    }

    private void handleWithOpenidAndParamsMap(String openId, Map<String, String> paramsMap, HttpServletRequest request, HttpServletResponse response) {
        WebApplicationContext applicationContext = ContextLoader.getCurrentWebApplicationContext();
        Map beanMaps = applicationContext.getBeansOfType(WechatOauthService.class);
        if (MapUtils.isEmpty((Map)beanMaps)) {
            return;
        }
        Set beanSet = beanMaps.keySet();
        Iterator iterator = beanSet.iterator();
        while (iterator.hasNext()) {
            ((WechatOauthService)beanMaps.get(iterator.next())).handleForOpenId(openId, paramsMap, request, response);
        }
    }

    private void handleWithWxUserAndParamsMap(WxMpUser wxMpUser, Map<String, String> paramsMap, HttpServletRequest request, HttpServletResponse response) {
        WebApplicationContext applicationContext = ContextLoader.getCurrentWebApplicationContext();
        Map beanMaps = applicationContext.getBeansOfType(WechatOauthService.class);
        if (MapUtils.isEmpty((Map)beanMaps)) {
            return;
        }
        Set beanSet = beanMaps.keySet();
        Iterator iterator = beanSet.iterator();
        while (iterator.hasNext()) {
            ((WechatOauthService)beanMaps.get(iterator.next())).handleForWxUser(wxMpUser, paramsMap, request, response);
        }
    }

    @ApiIgnore
    @RequestMapping(value={"/wechatOauth/front/oauth2WxUserInfo/{params}"})
    public ModelAndView receiveCodeAndGetWxUserInfo(@PathVariable(value="params") String params, String code, HttpServletRequest request, HttpServletResponse response) throws WxErrorException {
        logger.debug("receive wechat post code :" + code + ", with params :" + params);
        long t1 = System.currentTimeMillis();
        Map<String, String> paramsMap = null;
        String targetUrl = null;
        try {
            paramsMap = this.getParamsMapFromState(params);
            if (paramsMap != null) {
                targetUrl = paramsMap.get("TU");
                paramsMap.remove("TU");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AccountConfig accountConfig = this.accountConfigService.queryByOriginId(paramsMap.get("APPID"));
        WxMpService wxMpService = WxMpServiceUtils.getWxMpServiceByAccount(accountConfig);
        WxMpOAuth2AccessToken wxMpOAuth2AccessToken = wxMpService.oauth2getAccessToken(code);
        logger.debug("get oAuth2 AccessToken, cost [" + (System.currentTimeMillis() - t1) + "ms]");
        logger.debug("get oAuth2 AccessToken:" + wxMpOAuth2AccessToken);
        long t2 = System.currentTimeMillis();
        WxMpUser wxMpUser = wxMpService.oauth2getUserInfo(wxMpOAuth2AccessToken, null);
        logger.debug("get userinfo cost[" + (System.currentTimeMillis() - t2) + "ms]");
        logger.debug("get userInfo:" + wxMpUser);
        this.handleWithWxUserAndParamsMap(wxMpUser, paramsMap, request, response);
        String openId = wxMpOAuth2AccessToken.getOpenId();
        request.getSession().setAttribute("openid", (Object)openId);
        request.getSession().setAttribute("wxMpUser", (Object)wxMpUser);
        String serverName = StringUtils.substringBefore((String)StringUtils.substringBetween((String)targetUrl, (String)"://", (String)"/"), (String)":");
        if (StringUtils.isBlank((String)targetUrl)) {
            targetUrl = serverName + defaultPage;
        } else if (targetUrl.startsWith("/")) {
            targetUrl = serverName + targetUrl;
        }
        String viewName = "redirect:" + targetUrl;
        paramsMap.put("openid", openId);
        ModelAndView modelAndView = new ModelAndView(viewName, paramsMap);
        return modelAndView;
    }

    private Map<String, String> getParamsMapFromState(String params) throws JsonParseException, JsonMappingException, IOException {
        Hashtable<String, String> paramsMap = new Hashtable();
        if (StringUtils.isBlank((String)params)) {
            return null;
        }
        byte[] byteArray = Base64.decodeBase64((String)params);
        if ((params = new String(byteArray)).contains("\"")) {
            paramsMap = (Map)objectMapper.readValue(params, Map.class);
            logger.debug("get map from json :" + paramsMap);
        } else {
            Pattern tuPattern = Pattern.compile("((\\w+):(.+?))[\\,\\}]");
            Matcher tuMatcher = tuPattern.matcher(params);
            while (tuMatcher.find()) {
                String key = tuMatcher.group(2);
                String value = tuMatcher.group(3);
                if (!StringUtils.isNotBlank((String)key)) continue;
                paramsMap.put(key, value);
            }
        }
        return paramsMap;
    }

    @ApiOperation(httpMethod="GET", value="\u83b7\u53d6\u6388\u6743openid\u7684\u8df3\u8f6c\u5730\u5740")
    @RequestMapping(value={"wechatOauth/front/createOauthUrlForOpenid"})
    @ResponseBody
    public ResponseResult<String> createOauthUrlForOpenid(@ApiParam(value="\u6388\u6743\u7684\u9875\u9762") String url, @ApiParam(value="\u5fae\u4fe1\u516c\u4f17\u53f7\u7684\u539f\u59cbid\uff0c\u53ef\u4ee5\u4e0d\u586b") String originId, HttpServletRequest request) throws Exception {
        HashMap<String, String> paramsMap = null;
        String targetUrl = null;
        Matcher matcher = urlPatther.matcher(url);
        if (matcher.find()) {
            List list = URLEncodedUtils.parse((String)matcher.group(3), (Charset)Charset.forName("utf-8"));
            paramsMap = new HashMap<String, String>();
            for (int i = 0; i < list.size(); ++i) {
                NameValuePair params = (NameValuePair)list.get(i);
                System.out.println("name" + params.getName() + ",value" + params.getValue());
                paramsMap.put(params.getName(), params.getValue());
            }
            url = matcher.group(1);
        } else {
            targetUrl = url;
        }
        AccountConfig accountConfig = null;
        if (StringUtils.isNotBlank((String)originId)) {
            accountConfig = WxAccountConfigUtils.getByOrginId(originId);
        } else {
            String serverName = StringUtils.substringBetween((String)url, (String)"://", (String)"/");
            String requestUri = url.replaceAll("https?://.+?/", "/");
            accountConfig = this.accountConfigService.queryByRequest("http", serverName, 80, requestUri);
        }
        String oauthUrl = WechatOauthUtils.createOauthUrlForOpenid(targetUrl, paramsMap, accountConfig);
        return ResponseResult.success((Object)oauthUrl);
    }

    @ApiOperation(httpMethod="GET", value="\u83b7\u53d6\u4f1a\u5458\u8d44\u6599\u7684\u8df3\u8f6c\u5730\u5740")
    @RequestMapping(value={"wechatOauth/front/createOauthUrlForWxUserInfo"})
    @ResponseBody
    public ResponseResult<String> createOauthUrlForWxUserInfo(@ApiParam(value="\u6388\u6743\u7684\u9875\u9762") String url, @ApiParam(value="\u5fae\u4fe1\u516c\u4f17\u53f7\u7684\u539f\u59cbid\uff0c\u53ef\u4ee5\u4e0d\u586b") String originId, HttpServletRequest request) throws Exception {
        HashMap<String, String> paramsMap = null;
        String targetUrl = null;
        Matcher matcher = urlPatther.matcher(url);
        if (matcher.find()) {
            List list = URLEncodedUtils.parse((String)matcher.group(3), (Charset)Charset.forName("utf-8"));
            paramsMap = new HashMap<String, String>();
            for (int i = 0; i < list.size(); ++i) {
                NameValuePair params = (NameValuePair)list.get(i);
                System.out.println("name" + params.getName() + ",value" + params.getValue());
                paramsMap.put(params.getName(), params.getValue());
            }
            targetUrl = matcher.group(1);
        } else {
            targetUrl = url;
        }
        AccountConfig accountConfig = null;
        if (StringUtils.isNotBlank((String)originId)) {
            accountConfig = WxAccountConfigUtils.getByOrginId(originId);
        } else {
            String serverName = StringUtils.substringBetween((String)url, (String)"://", (String)"/");
            String requestUri = url.replaceAll("https?://.+?/", "/");
            accountConfig = this.accountConfigService.queryByRequest("http", serverName, 80, requestUri);
        }
        String oauthUrl = WechatOauthUtils.createOauthUrlForWxUserInfo(targetUrl, paramsMap, accountConfig);
        return ResponseResult.success((Object)oauthUrl);
    }
}

