/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.msg.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.wechat.account.service.AccountConfigService;
import com.els.base.wechat.msg.entity.WxMsgReplyNews;
import com.els.base.wechat.msg.entity.WxMsgReplyNewsExample;
import com.els.base.wechat.msg.service.WxMsgReplyNewsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u5fae\u4fe1-\u516c\u4f17\u53f7\u81ea\u5b9a\u4e49\u56fe\u6587\u6d88\u606f")
@Controller
@RequestMapping(value={"wxMsgReplyNews"})
public class WxMsgReplyNewsController {
    @Resource
    protected WxMsgReplyNewsService wxMsgReplyNewsService;
    @Autowired
    protected AccountConfigService accountConfigService;

    @ApiIgnore
    @RequestMapping(value={"service/toAddView"})
    public ModelAndView toAddView(@RequestParam(required=true, name="originId") String originId) {
        ModelAndView view = new ModelAndView("wechat/wxMsgReplyNews/toAddView");
        view.addObject("account", (Object)this.accountConfigService.queryByOriginId(originId));
        return view;
    }

    @ApiIgnore
    @RequestMapping(value={"service/toMainView"})
    public ModelAndView toMainView() {
        return new ModelAndView("wechat/wxMsgReplyNews/toMainView");
    }

    @ApiIgnore
    @RequestMapping(value={"service/toUpdateViewById"})
    public ModelAndView toUpdateViewById(int id, @RequestParam(required=true, name="originId") String originId) {
        ModelAndView view = new ModelAndView();
        WxMsgReplyNews wxMsgReplyNews = (WxMsgReplyNews)this.wxMsgReplyNewsService.queryObjById(id);
        view.addObject("wxMsgReplyNews", (Object)wxMsgReplyNews);
        view.addObject("account", (Object)this.accountConfigService.queryByOriginId(originId));
        view.setViewName("wechat/wxMsgReplyNews/toAddView");
        return view;
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u81ea\u5b9a\u4e49\u56fe\u6587\u6d88\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody WxMsgReplyNews wxMsgReplyNews) {
        this.wxMsgReplyNewsService.addObj(wxMsgReplyNews);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u81ea\u5b9a\u4e49\u56fe\u6587\u6d88\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody WxMsgReplyNews wxMsgReplyNews) {
        if (wxMsgReplyNews.getId() == null || wxMsgReplyNews.getId() <= 0) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.wxMsgReplyNewsService.modifyObj(wxMsgReplyNews);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u81ea\u5b9a\u4e49\u56fe\u6587\u6d88\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(int id) {
        this.wxMsgReplyNewsService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u81ea\u5b9a\u4e49\u56fe\u6587\u6d88\u606f")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<WxMsgReplyNews>> findByPage(@ApiParam(name="\u5206\u9875\u7d22\u5f15", defaultValue="0") @RequestParam(defaultValue="1") int pageNo, @ApiParam(name="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") String sSearch) {
        PageView pageView = new PageView(pageNo, pageSize);
        WxMsgReplyNewsExample example = new WxMsgReplyNewsExample();
        example.setPageView((PageView<WxMsgReplyNews>)pageView);
        if (StringUtils.isNotBlank((String)sSearch)) {
            // empty if block
        }
        return ResponseResult.success((Object)this.wxMsgReplyNewsService.queryObjByPage((IExample)example));
    }
}

