/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.msg.service.impl;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.common.CustomMessageRouter;
import com.els.base.wechat.common.WxMpServiceUtils;
import com.els.base.wechat.msg.WxMpMessageRouterFactory;
import com.els.base.wechat.msg.dao.WxMsgRuleMapper;
import com.els.base.wechat.msg.entity.WxMsgRule;
import com.els.base.wechat.msg.entity.WxMsgRuleExample;
import com.els.base.wechat.msg.service.WxMsgRuleService;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="wxMsgRuleService")
public class WxMsgRuleServiceImpl
implements WxMsgRuleService {
    @Resource
    protected WxMsgRuleMapper wxMsgRuleMapper;

    @CacheEvict(value={"wxMsgRule"}, allEntries=true)
    public void addObj(WxMsgRule t) {
        this.wxMsgRuleMapper.insertSelective(t);
    }

    @CacheEvict(value={"wxMsgRule"}, allEntries=true)
    public void deleteObjById(String id) {
        this.wxMsgRuleMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"wxMsgRule"}, allEntries=true)
    public void modifyObj(WxMsgRule t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        this.wxMsgRuleMapper.updateByPrimaryKeyWithBLOBs(t);
    }

    @Cacheable(value={"wxMsgRule"}, key="'WxMsgRuleService_' + #root.methodName + '_' +#id")
    public WxMsgRule queryObjById(String id) {
        return this.wxMsgRuleMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"wxMsgRule"}, key="'WxMsgRuleService_' + #root.methodName + '_'+ #example.toJson()")
    public List<WxMsgRule> queryAllObjByExample(WxMsgRuleExample example) {
        return this.wxMsgRuleMapper.selectByExampleWithBLOBs(example);
    }

    @Cacheable(value={"wxMsgRule"}, key="'WxMsgRuleService_' + #root.methodName + '_'+ #example.toJson()")
    public PageView<WxMsgRule> queryObjByPage(WxMsgRuleExample example) {
        PageView pageView = example.getPageView();
        if (pageView == null) {
            pageView = new PageView(1, 10);
            example.setPageView((PageView<WxMsgRule>)pageView);
        }
        pageView.setQueryResult(this.wxMsgRuleMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public CustomMessageRouter createRouter(AccountConfig account) {
        WxMsgRuleExample example = new WxMsgRuleExample();
        example.createCriteria().andWxAccountIdEqualTo(account.getId()).andIsEnableEqualTo(Constant.YES_INT);
        example.setOrderByClause("priority DESC");
        WxMsgRuleService wxMsgRuleService = (WxMsgRuleService)SpringContextHolder.getOneBean(WxMsgRuleService.class);
        List list = wxMsgRuleService.queryAllObjByExample((IExample)example);
        CustomMessageRouter router = null;
        try {
            router = WxMpMessageRouterFactory.build(list, WxMpServiceUtils.getWxMpServiceByAccount(account));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            throw new CommonException("\u521b\u5efa\u6d88\u606f\u5904\u7406\u5668\u5931\u8d25");
        }
        return router;
    }

    @CacheEvict(value={"wxMsgRule"}, allEntries=true)
    public void deleteByExample(WxMsgRuleExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.wxMsgRuleMapper.deleteByExample(example);
    }

    @CacheEvict(value={"wxMsgRule"}, allEntries=true)
    @Transactional
    public void addAll(List<WxMsgRule> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.wxMsgRuleMapper.insertSelective((WxMsgRule)record));
    }
}

