package com.els.base.wechat.msg.web.controller;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.wechat.msg.entity.WxMsgAutoReply;
import com.els.base.wechat.msg.entity.WxMsgAutoReplyExample;
import com.els.base.wechat.msg.service.WxMsgAutoReplyService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(value="微信-自动回复的消息规则")
@Controller
@RequestMapping("wxMsgAutoReply")
public class WxMsgAutoReplyController {
    @Resource
    protected WxMsgAutoReplyService wxMsgAutoReplyService;

    @ApiOperation(httpMethod="POST", value="创建自动回复的消息规则")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody WxMsgAutoReply wxMsgAutoReply) {
    	String originId = wxMsgAutoReply.getWxAccountOriginId();
    	
    	WxMsgAutoReplyExample example = new WxMsgAutoReplyExample();
    	example.createCriteria()
    	       .andWxAccountOriginIdEqualTo(originId)
    	       .andIsDefaultEqualTo(Constant.YES_INT);
    	List<WxMsgAutoReply> liset = this.wxMsgAutoReplyService.queryAllObjByExample(example);
    	if (CollectionUtils.isEmpty(liset)) {
			wxMsgAutoReply.setIsDefault(Constant.YES_INT);
		}
    	
        this.wxMsgAutoReplyService.addObj(wxMsgAutoReply);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑自动回复的消息规则")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody WxMsgAutoReply wxMsgAutoReply) {
        if (wxMsgAutoReply.getId() == null || wxMsgAutoReply.getId() <=0) {
            throw new CommonException("id 为空，保存失败");
        }
        this.wxMsgAutoReplyService.modifyObj(wxMsgAutoReply);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="删除自动回复的消息规则")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(int id) {
        this.wxMsgAutoReplyService.deleteObjById(id);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="GET", value="设置默认的自动回复内容")
    @RequestMapping("service/setDefaultById")
    @ResponseBody
    public ResponseResult<String> setDefaultById(
    		@RequestParam(required=true, name="originId") String originId,
    		int id) {
    	this.wxMsgAutoReplyService.setDefalutById(originId, id);
    	
    	return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="查询自动回复的消息规则")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<WxMsgAutoReply>> findByPage(
    		@ApiParam(value="分页索引",defaultValue="0") @RequestParam(defaultValue="1") int pageNo, 
    		@ApiParam(value="每页的数量",defaultValue="10") @RequestParam(defaultValue="10") int pageSize, 
    		@ApiParam(value="查询条件") @RequestParam(required=true,name="originId") String originId,
    		@ApiParam(value="查询条件") String sSearch) {
        PageView<WxMsgAutoReply> pageView = new PageView<>(pageNo, pageSize);
        WxMsgAutoReplyExample example = new WxMsgAutoReplyExample();
        example.setPageView(pageView);
        if (StringUtils.isNotBlank(sSearch)) {
            // TODO Auto-generated method stub
        }
        example.createCriteria().andWxAccountOriginIdEqualTo(originId);
        return ResponseResult.success(this.wxMsgAutoReplyService.queryObjByPage(example)) ;
    }
}