package com.els.base.wechat.login.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.wechat.login.dao.WxScanResultsMapper;
import com.els.base.wechat.login.entity.WxScanResults;
import com.els.base.wechat.login.entity.WxScanResultsExample;
import com.els.base.wechat.login.service.WxScanResultsService;
import com.els.base.wechat.member.entity.WxMember;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;

@Service("wxScanResultsService")
public class WxScanResultsServiceImpl implements WxScanResultsService {
    @Resource
    protected WxScanResultsMapper wxScanResultsMapper;

    @CacheEvict(value={"wxScanResults"}, allEntries=true)
    @Override
    public void addObj(WxScanResults t) {
        this.wxScanResultsMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"wxScanResults"}, allEntries=true)
    @Override
    public void addAll(List<WxScanResults> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.wxScanResultsMapper.insertBatch(list);
    }

    @CacheEvict(value={"wxScanResults"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.wxScanResultsMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"wxScanResults"}, allEntries=true)
    @Override
    public void deleteByExample(WxScanResultsExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.wxScanResultsMapper.deleteByExample(example);
    }

    @CacheEvict(value={"wxScanResults"}, allEntries=true)
    @Override
    public void modifyObj(WxScanResults t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.wxScanResultsMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="wxScanResults", keyGenerator="redisKeyGenerator")
    @Override
    public WxScanResults queryObjById(String id) {
        return this.wxScanResultsMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="wxScanResults", keyGenerator="redisKeyGenerator")
    @Override
    public List<WxScanResults> queryAllObjByExample(WxScanResultsExample example) {
        return this.wxScanResultsMapper.selectByExample(example);
    }

    @Cacheable(value="wxScanResults", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<WxScanResults> queryObjByPage(WxScanResultsExample example) {
        PageView<WxScanResults> pageView = example.getPageView();
        pageView.setQueryResult(this.wxScanResultsMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void createOrEditWxScanResults(String key, List<WxMember> memberList) {
        WxScanResultsExample example = new WxScanResultsExample();
        example.createCriteria().andCreateTimeLessThan(DateUtils.addDays(new Date(), -1));
        this.deleteByExample(example);
        WxScanResults wxScanResults = new WxScanResults();
        wxScanResults.setScanCode(key);
        wxScanResults.setIsEnable(Constant.YES_INT);
        wxScanResults.setCreateTime(new Date());
        if (CollectionUtils.isNotEmpty(memberList)) {
            wxScanResults.setOpenId(memberList.get(0).getWxOpenid());
            wxScanResults.setUserId(memberList.get(0).getMemberId());
        }
        this.addObj(wxScanResults);
    }

    @Override
    public String queryUserIdByKey(String key) {
        WxScanResultsExample example = new WxScanResultsExample();
        example.setOrderByClause("CREATE_TIME DESC");
        example.createCriteria().andScanCodeEqualTo("LOGIN_" + key);
        List<WxScanResults> list = this.queryAllObjByExample(example);
        if(CollectionUtils.isNotEmpty(list)){
            return list.get(0).getUserId();
        }
        return null;
    }
}