package com.els.base.wechat.account.entity;

import java.io.Serializable;

import com.els.base.wechat.common.CustomWxMpConfigStorage;
import com.els.base.wechat.common.CustomWxPayConfig;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.binarywang.wxpay.config.WxPayConfig;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;

@ApiModel(value="微信账号表")
public class AccountConfig implements Serializable {
	
	/**###################以下是非自动生成的###############################**/
	private WxMpConfigStorage wxMpConfigStorage = new CustomWxMpConfigStorage(this);

	private WxPayConfig wxPayConfig = new CustomWxPayConfig(this);
	
	@JsonIgnore
	public WxMpConfigStorage getWxMpConfigStorage() {
		return wxMpConfigStorage;
	}
	
	@JsonIgnore
	public WxPayConfig getWxPayConfig() {
		return wxPayConfig;
	}

	/**###################以下是非自动生成的###############################**/
	
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("公众号名字")
    private String name;

    @ApiModelProperty("公众号类型，1服务号，2订阅号，3企业号")
    private Integer accountType;

    @ApiModelProperty("微信号")
    private String code;

    @ApiModelProperty("原始id")
    private String originId;

    @ApiModelProperty("appId")
    private String appId;

    @ApiModelProperty("appSecret")
    private String appSecret;

    private String token;

    private String aesKey;

    @ApiModelProperty("加密模式，1明文模式，2兼容模式，3安全模式")
    private Integer encryptType;

    @ApiModelProperty("是否支持微信支付，1支持，0不支持")
    private Integer isPayEnable;

    @ApiModelProperty("微信支付，商户id")
    private String mchId;

    @ApiModelProperty("微信支付,商户key")
    private String mchKey;

    @ApiModelProperty("公众号服务器域名")
    private String domain;

    @ApiModelProperty("微信支付后的回调url，不带servername，path，默认wechatPay/notifyUrl")
    private String wxpayNotifyUrl;

    @ApiModelProperty("商户证书的存储路径")
    private String certPath;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code == null ? null : code.trim();
    }

    public String getOriginId() {
        return originId;
    }

    public void setOriginId(String originId) {
        this.originId = originId == null ? null : originId.trim();
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId == null ? null : appId.trim();
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret == null ? null : appSecret.trim();
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token == null ? null : token.trim();
    }

    public String getAesKey() {
        return aesKey;
    }

    public void setAesKey(String aesKey) {
        this.aesKey = aesKey == null ? null : aesKey.trim();
    }

    public Integer getEncryptType() {
        return encryptType;
    }

    public void setEncryptType(Integer encryptType) {
        this.encryptType = encryptType;
    }

    public Integer getIsPayEnable() {
        return isPayEnable;
    }

    public void setIsPayEnable(Integer isPayEnable) {
        this.isPayEnable = isPayEnable;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId == null ? null : mchId.trim();
    }

    public String getMchKey() {
        return mchKey;
    }

    public void setMchKey(String mchKey) {
        this.mchKey = mchKey == null ? null : mchKey.trim();
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain == null ? null : domain.trim();
    }

    public String getWxpayNotifyUrl() {
        return wxpayNotifyUrl;
    }

    public void setWxpayNotifyUrl(String wxpayNotifyUrl) {
        this.wxpayNotifyUrl = wxpayNotifyUrl == null ? null : wxpayNotifyUrl.trim();
    }

    public String getCertPath() {
        return certPath;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath == null ? null : certPath.trim();
    }
}