package com.els.base.wechat.redpack.controller;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.wechat.redpack.entity.WxRedpack;
import com.els.base.wechat.redpack.entity.WxRedpackExample;
import com.els.base.wechat.redpack.service.WxRedpackService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="微信-公众号推广红包")
@Controller
@RequestMapping("wxRedpack")
public class WxRedpackController {
    @Resource
    protected WxRedpackService wxRedpackService;

    @ApiIgnore
    @RequestMapping("service/toAddView")
    public ModelAndView toAddView() {
        return new ModelAndView("sns/wxRedpack/toAddView");
    }

    @ApiIgnore
    @RequestMapping("service/toMainView")
    public ModelAndView toMainView() {
        return new ModelAndView("sns/wxRedpack/toMainView");
    }

    @ApiIgnore
    @RequestMapping("service/toUpdateViewById")
    public ModelAndView toUpdateViewById(int id) {
        ModelAndView view = new ModelAndView();
        WxRedpack wxRedpack = this.wxRedpackService.queryObjById(id);
        view.addObject("wxRedpack", wxRedpack);
        view.setViewName("sns/wxRedpack/toAddView");
        return view;
    }

    @ApiOperation(httpMethod="POST", value="创建微信红包")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody WxRedpack wxRedpack) {
        this.wxRedpackService.addObj(wxRedpack);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑微信红包")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody WxRedpack wxRedpack) {
        if (wxRedpack.getId() == null || wxRedpack.getId() <=0) {
            throw new CommonException("id 为空，保存失败");
        }
        this.wxRedpackService.modifyObj(wxRedpack);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除微信红包")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(int id) {
        this.wxRedpackService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="查询微信红包")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<WxRedpack>> findByPage(
    		@ApiParam(name="分页索引",defaultValue="0") @RequestParam(defaultValue="0") int pageNo, 
    		@ApiParam(name="每页的数量",defaultValue="10") @RequestParam(defaultValue="10") int pageSize, 
    		@ApiParam(value="查询条件") String sSearch) {
        PageView<WxRedpack> pageView = new PageView<>(pageNo, pageSize);
        WxRedpackExample example = new WxRedpackExample();
        example.setPageView(pageView);
        if (StringUtils.isNotBlank(sSearch)) {
            // TODO Auto-generated method stub
        }
        return ResponseResult.success(this.wxRedpackService.queryObjByPage(example));
    }
    
}