/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.msg.utils;

import com.els.base.core.exception.CommonException;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.template.BeetlTemplateUtils;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.service.AccountConfigService;
import com.els.base.wechat.common.WxMpServiceUtils;
import com.els.base.wechat.member.entity.WxMember;
import com.els.base.wechat.msg.entity.WxTemplateMessage;
import com.els.base.wechat.msg.service.WxTemplateMessageService;
import java.util.regex.Pattern;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpTemplateMsgUtils {
    private static Logger logger = LoggerFactory.getLogger(WxMpTemplateMsgUtils.class);
    private static WxTemplateMessageService wxTemplateMessageService = (WxTemplateMessageService)SpringContextHolder.getOneBean(WxTemplateMessageService.class);
    private static AccountConfigService accountConfigService = (AccountConfigService)SpringContextHolder.getOneBean(AccountConfigService.class);
    private static Pattern pattern = Pattern.compile("\\$\\{\\s*\\w+(\\.\\w+)+\\s*\\}");

    public static boolean sendWxMpTemplateMessage(AccountConfig account, WxMpTemplateMessage templateMessage) {
        WxMpService wxMpService = WxMpServiceUtils.getWxMpServiceByAccount(account);
        String result = null;
        boolean isSuccess = true;
        try {
            result = wxMpService.getTemplateMsgService().sendTemplateMsg(templateMessage);
        }
        catch (Exception e) {
            logger.info("===== error in sending templateMessage =====" + result);
            e.printStackTrace();
            isSuccess = false;
        }
        logger.info("===== after sending templateMessage =====" + result);
        return isSuccess;
    }

    public static boolean sendWxMpTemplateMessage(AccountConfig account, WxTemplateMessage tplMsg, Object data, String receiverOpenid) {
        if (StringUtils.isBlank((String)tplMsg.getTemplateId())) {
            throw new CommonException("\u6a21\u677f\u6d88\u606f\u914d\u7f6e\u5f02\u5e38\uff0ctemplateId \u4e3a\u7a7a");
        }
        WxMpTemplateMessage templateMessage = new WxMpTemplateMessage();
        templateMessage.setToUser(receiverOpenid);
        templateMessage.setTemplateId(tplMsg.getTemplateId());
        String url = WxMpTemplateMsgUtils.getValueByTpl(tplMsg.getUrl(), data);
        templateMessage.setUrl(url);
        String first = WxMpTemplateMsgUtils.getValueByTpl(tplMsg.getFirst(), data);
        String firstColor = StringUtils.defaultIfBlank((String)tplMsg.getFirstColor(), (String)"#173177");
        templateMessage.getData().add(new WxMpTemplateData("first", first, firstColor));
        String keyword1 = WxMpTemplateMsgUtils.getValueByTpl(tplMsg.getKeyword1(), data);
        String keyword1Color = StringUtils.defaultIfBlank((String)tplMsg.getKeyword1Color(), (String)"#173177");
        templateMessage.getData().add(new WxMpTemplateData("keyword1", keyword1, keyword1Color));
        String keyword2 = WxMpTemplateMsgUtils.getValueByTpl(tplMsg.getKeyword2(), data);
        String keyword2Color = StringUtils.defaultIfBlank((String)tplMsg.getKeyword2Color(), (String)"#173177");
        templateMessage.getData().add(new WxMpTemplateData("keyword2", keyword2, keyword2Color));
        String keyword3 = WxMpTemplateMsgUtils.getValueByTpl(tplMsg.getKeyword3(), data);
        String keyword3Color = StringUtils.defaultIfBlank((String)tplMsg.getKeyword3Color(), (String)"#173177");
        templateMessage.getData().add(new WxMpTemplateData("keyword3", keyword3, keyword3Color));
        String keyword4 = WxMpTemplateMsgUtils.getValueByTpl(tplMsg.getKeyword4(), data);
        String keyword4Color = StringUtils.defaultIfBlank((String)tplMsg.getKeyword4Color(), (String)"#173177");
        templateMessage.getData().add(new WxMpTemplateData("keyword4", keyword4, keyword4Color));
        String keyword5 = WxMpTemplateMsgUtils.getValueByTpl(tplMsg.getKeyword5(), data);
        String keyword5Color = StringUtils.defaultIfBlank((String)tplMsg.getKeyword5Color(), (String)"#173177");
        templateMessage.getData().add(new WxMpTemplateData("keyword5", keyword5, keyword5Color));
        String remark = WxMpTemplateMsgUtils.getValueByTpl(tplMsg.getRemark(), data);
        String remarkColor = StringUtils.defaultIfBlank((String)tplMsg.getRemarkColor(), (String)"#173177");
        templateMessage.getData().add(new WxMpTemplateData("remark", remark, remarkColor));
        return WxMpTemplateMsgUtils.sendWxMpTemplateMessage(account, templateMessage);
    }

    public static boolean sendWxMpTemplateMessage(AccountConfig account, String businessType, Object data, String receiverOpenid) {
        WxTemplateMessage tplMsg = wxTemplateMessageService.queryByAccountAndType(account.getId(), businessType);
        return WxMpTemplateMsgUtils.sendWxMpTemplateMessage(account, tplMsg, data, receiverOpenid);
    }

    public static boolean sendWxMpTemplateMessage(String businessType, Object data, WxMember wxMember) {
        if (StringUtils.isBlank((String)wxMember.getWxOpenid())) {
            throw new CommonException("\u5fae\u4fe1\u4f1a\u5458\u4fe1\u606f\u4e2d\uff0c\u7f3a\u5c11openId\u4fe1\u606f");
        }
        if (StringUtils.isBlank((String)wxMember.getWxAccountOriginId())) {
            throw new CommonException("\u5fae\u4fe1\u4f1a\u5458\u4fe1\u606f\u4e2d\uff0c\u7f3a\u5c11\u516c\u4f17\u53f7orginId\u4fe1\u606f");
        }
        AccountConfig account = accountConfigService.queryByOriginId(wxMember.getWxAccountOriginId());
        if (account == null) {
            throw new CommonException("\u7cfb\u7edf\u627e\u4e0d\u5230originId[{" + wxMember.getWxAccountOriginId() + "}]\u7684\u516c\u4f17\u53f7");
        }
        WxTemplateMessage tplMsg = wxTemplateMessageService.queryByAccountAndType(account.getId(), businessType);
        return WxMpTemplateMsgUtils.sendWxMpTemplateMessage(account, tplMsg, data, wxMember.getWxOpenid());
    }

    private static String getValueByTpl(String first, Object data) {
        if (StringUtils.isNotBlank((String)first)) {
            try {
                first = BeetlTemplateUtils.renderFromString((String)first, (String)"data", (Object)data);
            }
            catch (Exception e) {
                logger.error("\u4f7f\u7528\u6a21\u677f\u5339\u914d\u5931\u8d25");
            }
        }
        return first;
    }

    public static boolean sendWxMpTemplateMessage(AccountConfig account, String templateType, String receiverOpenid, String url, String keyword1, String keyword2, String keyword3, String keyword4, String keyword5) throws Exception {
        return WxMpTemplateMsgUtils.sendWxMpTemplateMessage(account, templateType, receiverOpenid, null, null, url, null, keyword1, keyword2, keyword3, keyword4, keyword5);
    }

    public static boolean sendWxMpTemplateMessage(AccountConfig account, String templateType, String receiverOpenid, String first, String remark, String url, String color, String keyword1, String keyword2, String keyword3, String keyword4, String keyword5) throws Exception {
        WxTemplateMessage tplMsg = wxTemplateMessageService.queryByAccountAndType(account.getId(), templateType);
        if (StringUtils.isBlank((String)first)) {
            first = tplMsg.getFirst();
        }
        if (StringUtils.isBlank((String)remark)) {
            remark = tplMsg.getRemark();
        }
        WxMpTemplateMessage templateMessage = new WxMpTemplateMessage();
        templateMessage.setToUser(receiverOpenid);
        templateMessage.setTemplateId(tplMsg.getTemplateId());
        templateMessage.setUrl(url);
        String firstColor = StringUtils.defaultIfBlank((String)color, (String)StringUtils.defaultIfBlank((String)tplMsg.getFirstColor(), (String)"#173177"));
        templateMessage.getData().add(new WxMpTemplateData("first", first, firstColor));
        if (StringUtils.isNotBlank((String)keyword1)) {
            String keyword1Color = StringUtils.defaultIfBlank((String)color, (String)StringUtils.defaultIfBlank((String)tplMsg.getKeyword1Color(), (String)"#173177"));
            templateMessage.getData().add(new WxMpTemplateData("keyword1", keyword1, keyword1Color));
        }
        if (StringUtils.isNotBlank((String)keyword2)) {
            String keyword2Color = StringUtils.defaultIfBlank((String)color, (String)StringUtils.defaultIfBlank((String)tplMsg.getKeyword2Color(), (String)"#173177"));
            templateMessage.getData().add(new WxMpTemplateData("keyword2", keyword2, keyword2Color));
        }
        if (StringUtils.isNotBlank((String)keyword3)) {
            String keyword3Color = StringUtils.defaultIfBlank((String)color, (String)StringUtils.defaultIfBlank((String)tplMsg.getKeyword3Color(), (String)"#173177"));
            templateMessage.getData().add(new WxMpTemplateData("keyword3", keyword3, keyword3Color));
        }
        if (StringUtils.isNotBlank((String)keyword4)) {
            String keyword4Color = StringUtils.defaultIfBlank((String)color, (String)StringUtils.defaultIfBlank((String)tplMsg.getKeyword4Color(), (String)"#173177"));
            templateMessage.getData().add(new WxMpTemplateData("keyword4", keyword4, keyword4Color));
        }
        if (StringUtils.isNotBlank((String)keyword5)) {
            String keyword5Color = StringUtils.defaultIfBlank((String)color, (String)StringUtils.defaultIfBlank((String)tplMsg.getKeyword5Color(), (String)"#173177"));
            templateMessage.getData().add(new WxMpTemplateData("keyword5", keyword5, keyword5Color));
        }
        String remarkColor = StringUtils.defaultIfBlank((String)color, (String)StringUtils.defaultIfBlank((String)tplMsg.getRemarkColor(), (String)"#173177"));
        templateMessage.getData().add(new WxMpTemplateData("remark", remark, remarkColor));
        return WxMpTemplateMsgUtils.sendWxMpTemplateMessage(account, templateMessage);
    }
}

