package com.els.base.wechat.msg.service.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.common.CustomMessageRouter;
import com.els.base.wechat.common.WxMpServiceUtils;
import com.els.base.wechat.msg.WxMpMessageRouterFactory;
import com.els.base.wechat.msg.dao.WxMsgRuleMapper;
import com.els.base.wechat.msg.entity.WxMsgRule;
import com.els.base.wechat.msg.entity.WxMsgRuleExample;
import com.els.base.wechat.msg.service.WxMsgRuleService;

@Service("wxMsgRuleService")
public class WxMsgRuleServiceImpl implements WxMsgRuleService {
    @Resource
    protected WxMsgRuleMapper wxMsgRuleMapper;

    @CacheEvict(value={"wxMsgRule"}, allEntries=true)
    @Override
    public void addObj(WxMsgRule t) {
        this.wxMsgRuleMapper.insertSelective(t);
    }

    @CacheEvict(value={"wxMsgRule"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.wxMsgRuleMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"wxMsgRule"}, allEntries=true)
    @Override
    public void modifyObj(WxMsgRule t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法更新");
        this.wxMsgRuleMapper.updateByPrimaryKeyWithBLOBs(t);
//        this.wxMsgRuleMapper.updateByPrimaryKeyWithBLOBs(record)
    }

    @Cacheable(value="wxMsgRule", key="'WxMsgRuleService_' + #root.methodName + '_' +#id")
    @Override
    public WxMsgRule queryObjById(String id) {
        return this.wxMsgRuleMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="wxMsgRule", key="'WxMsgRuleService_' + #root.methodName + '_'+ #example.toJson()")
    @Override
    public List<WxMsgRule> queryAllObjByExample(WxMsgRuleExample example) {
        return this.wxMsgRuleMapper.selectByExampleWithBLOBs(example);
    }

    @Cacheable(value="wxMsgRule", key="'WxMsgRuleService_' + #root.methodName + '_'+ #example.toJson()")
    @Override
    public PageView<WxMsgRule> queryObjByPage(WxMsgRuleExample example) {
        PageView<WxMsgRule> pageView = example.getPageView();
        if (pageView == null) {
            pageView = new PageView<>(1, 10);
            example.setPageView(pageView);
        }
        pageView.setQueryResult(this.wxMsgRuleMapper.selectByExampleByPage(example));
        return pageView;
    }

	@Override
	public CustomMessageRouter createRouter(AccountConfig account) {
    	WxMsgRuleExample example = new WxMsgRuleExample();
    	example.createCriteria()
    	       .andWxAccountIdEqualTo(account.getId())
    	       .andIsEnableEqualTo(Constant.YES_INT);
    	
    	example.setOrderByClause("priority DESC");
    	
    	WxMsgRuleService wxMsgRuleService = SpringContextHolder.getOneBean(WxMsgRuleService.class);
    	List<WxMsgRule> list = wxMsgRuleService.queryAllObjByExample(example);
    	
    	CustomMessageRouter router = null;
		try {
			router = WxMpMessageRouterFactory.build(list, WxMpServiceUtils.getWxMpServiceByAccount(account));
		
		} catch (ClassNotFoundException | NoSuchMethodException | SecurityException | InstantiationException
				| IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
			e.printStackTrace();
			throw new CommonException("创建消息处理器失败");
		}
		return router;
	}
	
	@CacheEvict(value={"wxMsgRule"}, allEntries=true)
	@Override
	public void deleteByExample(WxMsgRuleExample example) {
    	Assert.isNotNull(example, "参数不能为空");
    	Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
    	
    	this.wxMsgRuleMapper.deleteByExample(example);		
	}

    @CacheEvict(value={"wxMsgRule"}, allEntries=true)
    @Transactional
	@Override
	public void addAll(List<WxMsgRule> list) {
		if (CollectionUtils.isEmpty(list)) {
   			return;
   		}
   		
   		list.forEach(record ->{
   			this.wxMsgRuleMapper.insertSelective(record);		
   		});		
	}
}