/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.login.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.wechat.login.dao.WxScanResultsMapper;
import com.els.base.wechat.login.entity.WxScanResults;
import com.els.base.wechat.login.entity.WxScanResultsExample;
import com.els.base.wechat.login.service.WxScanResultsService;
import com.els.base.wechat.member.entity.WxMember;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="wxScanResultsService")
public class WxScanResultsServiceImpl
implements WxScanResultsService {
    @Resource
    protected WxScanResultsMapper wxScanResultsMapper;

    @CacheEvict(value={"wxScanResults"}, allEntries=true)
    public void addObj(WxScanResults t) {
        this.wxScanResultsMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"wxScanResults"}, allEntries=true)
    public void addAll(List<WxScanResults> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.wxScanResultsMapper.insertBatch(list);
    }

    @CacheEvict(value={"wxScanResults"}, allEntries=true)
    public void deleteObjById(String id) {
        this.wxScanResultsMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"wxScanResults"}, allEntries=true)
    public void deleteByExample(WxScanResultsExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.wxScanResultsMapper.deleteByExample(example);
    }

    @CacheEvict(value={"wxScanResults"}, allEntries=true)
    public void modifyObj(WxScanResults t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.wxScanResultsMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"wxScanResults"}, keyGenerator="redisKeyGenerator")
    public WxScanResults queryObjById(String id) {
        return this.wxScanResultsMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"wxScanResults"}, keyGenerator="redisKeyGenerator")
    public List<WxScanResults> queryAllObjByExample(WxScanResultsExample example) {
        return this.wxScanResultsMapper.selectByExample(example);
    }

    @Cacheable(value={"wxScanResults"}, keyGenerator="redisKeyGenerator")
    public PageView<WxScanResults> queryObjByPage(WxScanResultsExample example) {
        PageView<WxScanResults> pageView = example.getPageView();
        pageView.setQueryResult(this.wxScanResultsMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void createOrEditWxScanResults(String key, List<WxMember> memberList) {
        WxScanResultsExample example = new WxScanResultsExample();
        example.createCriteria().andCreateTimeLessThan(DateUtils.addDays((Date)new Date(), (int)-1));
        this.deleteByExample(example);
        WxScanResults wxScanResults = new WxScanResults();
        wxScanResults.setScanCode(key);
        wxScanResults.setIsEnable(Constant.YES_INT);
        wxScanResults.setCreateTime(new Date());
        if (CollectionUtils.isNotEmpty(memberList)) {
            wxScanResults.setOpenId(memberList.get(0).getWxOpenid());
            wxScanResults.setUserId(memberList.get(0).getMemberId());
        }
        this.addObj(wxScanResults);
    }

    @Override
    public WxScanResults queryUserIdByKey(String key) {
        WxScanResultsExample example = new WxScanResultsExample();
        example.setOrderByClause("CREATE_TIME DESC");
        example.createCriteria().andScanCodeEqualTo("LOGIN_" + key);
        List<WxScanResults> list = this.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }
}

