package com.els.base.wechat.msg.handler;

import com.els.base.utils.SpringContextHolder;
import com.els.base.wechat.login.service.WxScanResultsService;
import com.els.base.wechat.member.entity.WxMember;
import com.els.base.wechat.member.entity.WxMemberExample;
import com.els.base.wechat.member.service.WxMemberService;
import com.els.base.wechat.msg.entity.WxMsgRule;
import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;

import java.util.List;
import java.util.Map;

/**
 * @Auther: ouchehai
 * @Date: 2019/4/17 15:04
 * @Description:
 */
public class LoginScanRrcodeHandler extends BaseMsgHandler {


    public LoginScanRrcodeHandler(WxMsgRule wxMsgRule) {
        super(wxMsgRule);
    }
    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService, WxSessionManager sessionManager) throws WxErrorException {
        if (!WxConsts.XML_MSG_EVENT.equals(wxMessage.getMsgType())) {
            return null;
        }

        if (!WxConsts.EVT_SCAN.equals(wxMessage.getEvent()) && !WxConsts.EVT_SUBSCRIBE.equals(wxMessage.getEvent())) {
            return null;
        }
        String key = wxMessage.getEventKey().replaceAll("qrscene_", "");
        if (!key.startsWith("LOGIN_")) {
            return null;
        } else {
            WxMemberExample wxMemberExample = new WxMemberExample();
            wxMemberExample.createCriteria().andWxOpenidEqualTo(wxMessage.getFromUser());
            WxMemberService wxMemberService = (WxMemberService)SpringContextHolder.getBean("wxMemberService");
            List<WxMember> memberList = wxMemberService.queryAllObjByExample(wxMemberExample);

            WxScanResultsService wxScanResultsService = (WxScanResultsService)SpringContextHolder.getBean("wxScanResultsService");
            wxScanResultsService.createOrEditWxScanResults(key, memberList);

           return null;
        }

    }
}
