package com.els.base.wechat.menu.web.controller;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.ResponseResult;
import com.els.base.utils.json.JsonUtils;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.service.AccountConfigService;
import com.els.base.wechat.common.WxMpServiceUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.bean.menu.WxMpMenu;

/**
 * 微信自定义菜单控制器
 * Created by Benson on 2016/8/21.
 */
@Api("微信-公众号自定义菜单接口")
@Controller
@RequestMapping("wechatMenu")
public class WechatMenuController {
    @Resource
    protected AccountConfigService accountConfigService;

    /**
	 * 获取菜单
	 * @param originId
	 * @return
	 * @throws WxErrorException
	 * @author Leiming
	 */
    @ApiOperation(httpMethod="GET", value="查询微信菜单")
	@RequestMapping(value="/service/menuGet", produces = "application/json;charset=UTF-8")
	@ResponseBody
	public ResponseResult<WxMpMenu> menuGet(@RequestParam(required=true, value="originId") String originId) throws WxErrorException{
//		AccountConfig account = accountConfigService.queryObjById(accountId);
		AccountConfig account = accountConfigService.queryByOriginId(originId);
		WxMpServiceImpl wxMpService = (WxMpServiceImpl) WxMpServiceUtils.getWxMpServiceByAccount(account);
		
		WxMpMenu wxMenu = wxMpService.getMenuService().menuGet();
		
		return ResponseResult.success(wxMenu);
	}
	
	/**
     * 创建或更新菜单
     * @param originId
     * @param wxMenu
     * @return
     * @throws Exception
     */
	@ApiOperation(httpMethod="POST", value="创建或更新微信菜单")
    @RequestMapping(value="service/create",  produces = "application/json;charset=UTF-8")
	@ResponseBody
	public ResponseResult<WxMpMenu> create(@RequestParam(required=true, value="originId") String originId, @RequestBody WxMpMenu wxMenu) throws Exception {		
		
		AccountConfig account = accountConfigService.queryByOriginId(originId);
		
		WxMpServiceImpl wxMpService = (WxMpServiceImpl) WxMpServiceUtils.getWxMpServiceByAccount(account);
		
		if (CollectionUtils.isEmpty(wxMenu.getMenu().getButtons())) {
			wxMpService.getMenuService().menuDelete();
		}else{
			wxMpService.getMenuService().menuCreate(JsonUtils.writeValueAsString(wxMenu.getMenu()));
		}
		
		WxMpMenu newMenu = wxMpService.getMenuService().menuGet();
		
		return ResponseResult.success(newMenu);
	}
}
