/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.pay.web.controller;

import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.http.HttpRequestUtils;
import com.els.base.wechat.common.utils.XmlUtils;
import com.els.base.wechat.pay.entity.WxMpXmlInOrderQueryMessage;
import com.els.base.wechat.pay.entity.WxMpXmlUnifiedOrderInMessage;
import com.els.base.wechat.pay.service.WechatPayNotifyService;
import io.swagger.annotations.Api;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5fae\u4fe1-\u7f51\u9875\u652f\u4ed8")
@Controller(value="wechatPayController")
public class WechatPayController {
    private Logger logger = LoggerFactory.getLogger(WechatPayController.class);

    @RequestMapping(value={"wechatPay/front/notifyUrl"})
    @ResponseBody
    public String payResultNotify(HttpServletRequest request) throws IOException {
        WechatPayNotifyService wechatPayNotifyService = (WechatPayNotifyService)SpringContextHolder.getOneBean(WechatPayNotifyService.class);
        String requestBody = HttpRequestUtils.getRequestBody((HttpServletRequest)request);
        this.logger.info("receive PayResult notify:" + requestBody);
        WxMpXmlInOrderQueryMessage inMsg = XmlUtils.parseXMl(requestBody, WxMpXmlInOrderQueryMessage.class);
        if (wechatPayNotifyService != null) {
            wechatPayNotifyService.handlePaidNotifyMsg(inMsg);
        }
        WxMpXmlUnifiedOrderInMessage resultMsg = new WxMpXmlUnifiedOrderInMessage();
        resultMsg.setReturnCode("SUCCESS");
        resultMsg.setResultCode("OK");
        return resultMsg.toXml();
    }
}

