package com.els.base.wechat.common;

import java.util.Hashtable;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.els.base.wechat.account.entity.AccountConfig;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;

public class WxPayServiceUtils {
	
	public static final ThreadLocal<WxPayService> wxPayServiceThreadLocal = new ThreadLocal<>();
	public static Map<String, WxPayService> wxPayServiceMap = new Hashtable<>();
	
	public static void setInThreadLocal(WxPayService wxPayService){
		wxPayServiceThreadLocal.set(wxPayService);
	}
	
	public static WxPayService getWxMpServiceFromThreadLocal(){
		return wxPayServiceThreadLocal.get();
	}
	/*
	public static WxPayService getWxMpServiceByAccount(AccountConfig accountConfig){
		return WxMpServicePool.getWxMpServiceByAccount(accountConfig);
	}*/
	
//	public static WxPayService getWxMpServiceByRequest(HttpServletRequest request) {
//		AccountConfigService accountConfigService = SpringContextHolder.getOneBean(AccountConfigService.class);
//		AccountConfig accountConfig = accountConfigService.queryByRequest(request);
//		return getWxMpServiceByAccount(accountConfig);
//	}

	public static WxPayService getWxPayServiceByAccount(AccountConfig accountConfig) {
		if (accountConfig == null) {
			return null;
		}
		
		String appId = accountConfig.getAppId();
		if (StringUtils.isBlank(appId)) {
			throw new NullPointerException("公众号配置中，appid不能为空");
		}
		
		if (wxPayServiceMap.get(appId) != null) {
			return wxPayServiceMap.get(appId);
		}
		
		synchronized (wxPayServiceMap) {
			if (wxPayServiceMap.get(appId) == null) {
				WxPayService service = new WxPayServiceImpl();
				service.setConfig(accountConfig.getWxPayConfig());
				wxPayServiceMap.put(appId, service);
			}
		}
		
		return wxPayServiceMap.get(appId);
//		WxPayService service = new McodingWxMpServiceImpl(accountConfig);
//		WxPayService service = new WxMpServiceImpl();
//		service.setWxMpConfigStorage(accountConfig);
//		return service;
	}


}
