package com.els.base.wechat.login.controller;

import com.els.base.wechat.account.utils.WxAccountConfigUtils;
import com.els.base.wechat.common.WxMpServiceUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpQrcodeService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpQrCodeTicket;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * @Auther: ouchehai
 * @Date: 2019/4/17 15:00
 * @Description:
 */
@Api(value="微信扫描登录")
@Controller
@RequestMapping("wxLoginQrCode")
public class WxLoginQrCodeController {

    @ApiOperation(
            httpMethod = "GET",
            value = "创建微信登录二维码"
    )
    @RequestMapping({"service/createQrcodeForLogin"})
    @ResponseBody
    public ModelAndView createQrcodeForLogin(String key, HttpServletResponse response) throws WxErrorException, IOException {
        WxMpService wxMpService = WxMpServiceUtils.getWxMpServiceByAccount(WxAccountConfigUtils.getDefaultAccountFromConfig());

        String sceneStr = "LOGIN_" + key;
        WxMpQrcodeService qrcodeService = wxMpService.getQrcodeService();
        WxMpQrCodeTicket ticket = qrcodeService.qrCodeCreateTmpTicket(sceneStr, 30);
        File file = qrcodeService.qrCodePicture(ticket);
        response.addHeader("Content-Disposition", "inline;filename=\"" + URLEncoder.encode("loginQrcode.jpg", "UTF-8") + "\";");
        response.setContentType("image/jpg");
        OutputStream outputStream = response.getOutputStream();
        byte[] tmp = new byte[1024];
        FileInputStream inputStream = new FileInputStream(file);

        while(inputStream.read(tmp) != -1) {
            outputStream.write(tmp);
        }

        outputStream.flush();
        outputStream.close();
        inputStream.close();
        return null;
    }
}