/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.account.utils;

import com.els.base.core.exception.CommonException;
import com.els.base.utils.SpringContextHolder;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.service.AccountConfigService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public abstract class WxAccountConfigUtils {
    private static AccountConfigService accountConfigService = (AccountConfigService)SpringContextHolder.getOneBean(AccountConfigService.class);

    public static AccountConfig getByOrginId(String originId) {
        return accountConfigService.queryByOriginId(originId);
    }

    public static AccountConfig getDefaultAccountFromConfig() {
        List defaultConfList = accountConfigService.queryAllObjByExample(null);
        if (CollectionUtils.isEmpty((Collection)defaultConfList)) {
            throw new CommonException("\u7cfb\u7edf\u6ca1\u6709\u914d\u7f6e\u9ed8\u8ba4\u7684\u516c\u4f17\u53f7\u5e10\u53f7 [wx.account.originId] ");
        }
        if (defaultConfList.size() == 1) {
            return (AccountConfig)defaultConfList.get(0);
        }
        String originId = SpringContextHolder.getProperty((String)"wx.account.originId");
        if (StringUtils.isBlank((String)originId)) {
            throw new CommonException("\u7cfb\u7edf\u6ca1\u6709\u914d\u7f6e\u9ed8\u8ba4\u7684\u516c\u4f17\u53f7\u5e10\u53f7 [wx.account.originId] ");
        }
        return WxAccountConfigUtils.getByOrginId(originId);
    }
}

