/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.wechat.redpack.service.impl;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.wechat.redpack.dao.WxRedpackMapper;
import com.els.base.wechat.redpack.entity.WxRedpack;
import com.els.base.wechat.redpack.entity.WxRedpackExample;
import com.els.base.wechat.redpack.service.WxRedpackService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="wxRedpackService")
public class WxRedpackServiceImpl
implements WxRedpackService {
    @Resource
    protected WxRedpackMapper wxRedpackMapper;

    @CacheEvict(value={"wxRedpack"}, allEntries=true)
    public void addObj(WxRedpack t) {
        this.wxRedpackMapper.insertSelective(t);
    }

    @CacheEvict(value={"wxRedpack"}, allEntries=true)
    public void deleteObjById(Integer id) {
        this.wxRedpackMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"wxRedpack"}, allEntries=true)
    public void modifyObj(WxRedpack t) {
        if (t.getId() == null || t.getId() == 0) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.wxRedpackMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"wxRedpack"}, key="'WxRedpackService_' + #root.methodName + '_' +#id")
    public WxRedpack queryObjById(Integer id) {
        return (WxRedpack)this.wxRedpackMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"wxRedpack"}, key="'WxRedpackService_' + #root.methodName + '_'+ #example.toJson()")
    public List<WxRedpack> queryAllObjByExample(WxRedpackExample example) {
        return this.wxRedpackMapper.selectByExample((IExample)example);
    }

    @Cacheable(value={"wxRedpack"}, key="'WxRedpackService_' + #root.methodName + '_'+ #example.toJson()")
    public PageView<WxRedpack> queryObjByPage(WxRedpackExample example) {
        PageView pageView = example.getPageView();
        if (pageView == null) {
            pageView = new PageView(1, 10);
            example.setPageView((PageView<WxRedpack>)pageView);
        }
        pageView.setQueryResult(this.wxRedpackMapper.selectByExampleByPage((IExample)example));
        return pageView;
    }

    @Override
    public WxRedpack queryByCode(String redpackCode) {
        WxRedpackExample example = new WxRedpackExample();
        example.createCriteria().andRedpackCodeEqualTo(redpackCode);
        List<WxRedpack> list = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @CacheEvict(value={"wxRedpack"}, allEntries=true)
    public void deleteByExample(WxRedpackExample example) {
        Assert.isNotNull((Object)((Object)example), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.wxRedpackMapper.deleteByExample((IExample)example);
    }

    @CacheEvict(value={"wxRedpack"}, allEntries=true)
    @Transactional
    public void addAll(List<WxRedpack> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.wxRedpackMapper.insertSelective((Serializable)record));
    }
}

