package com.els.base.wechat.common;

import java.io.Serializable;

import com.els.base.wechat.account.entity.AccountConfig;
import com.github.binarywang.wxpay.config.WxPayConfig;

public class CustomWxPayConfig extends WxPayConfig implements Serializable{
	
	private static final long serialVersionUID = 1L;
	private AccountConfig accountConfig;

	public CustomWxPayConfig(AccountConfig accountConfig) {
		super();
		this.accountConfig = accountConfig;
	}

	@Override
	public String getKeyPath() {
		return this.accountConfig.getCertPath();
	}

	@Override
	public String getMchId() {
		return this.accountConfig.getMchId();
	}

	@Override
	public String getMchKey() {
		return this.accountConfig.getMchKey();
	}

	@Override
	public String getAppId() {
		return this.accountConfig.getAppId();
	}

	@Override
	public String getNotifyUrl() {
		return this.accountConfig.getDomain().replaceAll("\\/+\\s*$", "") + "/" + WxConstant.URL_PAID_NOTIFY;
	}

	@Override
	public String getTradeType() {
		return super.getTradeType();
	}
	
	
	
	
}
