package com.els.base.wechat.msg.utils;


import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.els.base.core.exception.CommonException;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.template.BeetlTemplateUtils;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.service.AccountConfigService;
import com.els.base.wechat.common.WxMpServiceUtils;
import com.els.base.wechat.member.entity.WxMember;
import com.els.base.wechat.msg.entity.WxTemplateMessage;
import com.els.base.wechat.msg.service.WxTemplateMessageService;

import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;

public class WxMpTemplateMsgUtils {

	private static Logger logger = LoggerFactory.getLogger(WxMpTemplateMsgUtils.class);
	private static WxTemplateMessageService wxTemplateMessageService = SpringContextHolder.getOneBean(WxTemplateMessageService.class);
	private static AccountConfigService accountConfigService = SpringContextHolder.getOneBean(AccountConfigService.class);
	private static Pattern pattern = Pattern.compile("\\$\\{\\s*\\w+(\\.\\w+)+\\s*\\}");
	
	/**
	 * 发送模板消息，模板消息具体内容自定义
	 * @param account
	 * @param templateMessage
	 * @return
	 */
	public static boolean sendWxMpTemplateMessage(AccountConfig account, WxMpTemplateMessage templateMessage) {

		WxMpService wxMpService = WxMpServiceUtils.getWxMpServiceByAccount(account);
		String result = null;
		boolean isSuccess = true;
		try {
			result = wxMpService.getTemplateMsgService().sendTemplateMsg(templateMessage);
		} catch (Exception e) {
			logger.info("===== error in sending templateMessage =====" + result);
			e.printStackTrace();
			isSuccess = false;
		}
		logger.info("===== after sending templateMessage =====" + result);
		return isSuccess;
	}
	
	/**
	 * 发送模板消息，模板消息具体内容自定义
	 * @param account
	 * @param tplMsg
	 * @return
	 */
	public static boolean sendWxMpTemplateMessage(AccountConfig account, WxTemplateMessage tplMsg, Object data, String receiverOpenid) {
		
		if (StringUtils.isBlank(tplMsg.getTemplateId())) {
			throw new CommonException("模板消息配置异常，templateId 为空");
		}
		
		WxMpTemplateMessage templateMessage = new WxMpTemplateMessage();
		templateMessage.setToUser(receiverOpenid);
		templateMessage.setTemplateId(tplMsg.getTemplateId());

		String url = getValueByTpl(tplMsg.getUrl(), data);
		templateMessage.setUrl(url);
		
		String first = getValueByTpl(tplMsg.getFirst(), data);
		String firstColor = StringUtils.defaultIfBlank(tplMsg.getFirstColor(), WxTemplateMessage.DEFAULT_COLOR);
		templateMessage.getData().add(new WxMpTemplateData("first", first, firstColor));
		
		String keyword1 = getValueByTpl(tplMsg.getKeyword1(), data);
		String keyword1Color = StringUtils.defaultIfBlank(tplMsg.getKeyword1Color(), WxTemplateMessage.DEFAULT_COLOR);
		templateMessage.getData().add(new WxMpTemplateData("keyword1", keyword1, keyword1Color));
		
		String keyword2 = getValueByTpl(tplMsg.getKeyword2(), data);
		String keyword2Color = StringUtils.defaultIfBlank(tplMsg.getKeyword2Color(), WxTemplateMessage.DEFAULT_COLOR);
		templateMessage.getData().add(new WxMpTemplateData("keyword2", keyword2, keyword2Color));
		
		String keyword3 = getValueByTpl(tplMsg.getKeyword3(), data);
		String keyword3Color = StringUtils.defaultIfBlank(tplMsg.getKeyword3Color(), WxTemplateMessage.DEFAULT_COLOR);
		templateMessage.getData().add(new WxMpTemplateData("keyword3", keyword3, keyword3Color));
		
		String keyword4 = getValueByTpl(tplMsg.getKeyword4(), data);
		String keyword4Color = StringUtils.defaultIfBlank(tplMsg.getKeyword4Color(), WxTemplateMessage.DEFAULT_COLOR);
		templateMessage.getData().add(new WxMpTemplateData("keyword4", keyword4, keyword4Color));
		
		String keyword5 = getValueByTpl(tplMsg.getKeyword5(), data);
		String keyword5Color = StringUtils.defaultIfBlank(tplMsg.getKeyword5Color(), WxTemplateMessage.DEFAULT_COLOR);
		templateMessage.getData().add(new WxMpTemplateData("keyword5", keyword5, keyword5Color));
		
		String remark = getValueByTpl(tplMsg.getRemark(), data);
		String remarkColor = StringUtils.defaultIfBlank(tplMsg.getRemarkColor(), WxTemplateMessage.DEFAULT_COLOR);
		templateMessage.getData().add(new WxMpTemplateData("remark", remark, remarkColor));
		
		return sendWxMpTemplateMessage(account, templateMessage);
	}
	
	/**
	 * 发送模板消息，模板消息具体内容自定义
	 * @param account
	 * @param tplMsg
	 * @return
	 */
	public static boolean sendWxMpTemplateMessage(AccountConfig account, String businessType, Object data, String receiverOpenid) {
		
		WxTemplateMessage tplMsg = wxTemplateMessageService.queryByAccountAndType(account.getId(), businessType);
		return sendWxMpTemplateMessage(account, tplMsg, data, receiverOpenid);
	}
	
	/**
	 * 发送模板消息，模板消息具体内容自定义
	 * @param account
	 * @param tplMsg
	 * @return
	 */
	public static boolean sendWxMpTemplateMessage(String businessType, Object data, WxMember wxMember) {
		if (StringUtils.isBlank(wxMember.getWxOpenid())) {
			throw new CommonException("微信会员信息中，缺少openId信息");
		}
		if (StringUtils.isBlank(wxMember.getWxAccountOriginId())) {
			throw new CommonException("微信会员信息中，缺少公众号orginId信息");
		}
		AccountConfig account = accountConfigService.queryByOriginId(wxMember.getWxAccountOriginId());
		if (account == null) {
			throw new CommonException("系统找不到originId[{"+wxMember.getWxAccountOriginId()+"}]的公众号");
		}
		
		WxTemplateMessage tplMsg = wxTemplateMessageService.queryByAccountAndType(account.getId(), businessType);
		return sendWxMpTemplateMessage(account, tplMsg, data, wxMember.getWxOpenid());
	}
	
	private static String getValueByTpl(String first, Object data){
		if (StringUtils.isNotBlank(first)) {
			try {
				first = BeetlTemplateUtils.renderFromString(first, "data", data);
			} catch (Exception e) {
				logger.error("使用模板匹配失败");
			}
		}
		return first;
	}

	/**
	 * 发送模板消息，templateId，first，remark根据数据库配置生成，其余自定义
	 * @param account
	 * @param templateType
	 * @param receiverOpenid
	 * @param url
	 * @param keyword1
	 * @param keyword2
	 * @param keyword3
	 * @param keyword4
	 * @param keyword5
	 * @return
	 * @throws Exception
	 */
	public static boolean sendWxMpTemplateMessage(AccountConfig account, String templateType, String receiverOpenid,
			String url, String keyword1, String keyword2, String keyword3, String keyword4, String keyword5)
					throws Exception {
		return sendWxMpTemplateMessage(account, templateType, receiverOpenid, null, null, url, null, keyword1, keyword2, keyword3, keyword4, keyword5);
	}

	/**
	 * 发送模板消息,templateId根据数据库配置，其余字段自定义
	 * @param account
	 * @param templateType
	 * @param receiverOpenid
	 * @param first
	 * @param remark
	 * @param url
	 * @param color
	 * @param keyword1
	 * @param keyword2
	 * @param keyword3
	 * @param keyword4
	 * @param keyword5
	 * @return
	 * @throws Exception
	 */
	public static boolean sendWxMpTemplateMessage(AccountConfig account, String templateType, String receiverOpenid,
			String first, String remark, String url, String color, String keyword1, String keyword2, String keyword3,
			String keyword4, String keyword5) throws Exception {
				
//		WxTemplateMessage tplMsg = getService().queryByAccountAndType(account.getId(), templateType);
		WxTemplateMessage tplMsg = wxTemplateMessageService.queryByAccountAndType(account.getId(), templateType);
		if (StringUtils.isBlank(first)) {
			first = tplMsg.getFirst();
		}
		if (StringUtils.isBlank(remark)) {
			remark = tplMsg.getRemark();
		}
		
		// 推送用户支付成功的模板消息
		WxMpTemplateMessage templateMessage = new WxMpTemplateMessage();
		templateMessage.setToUser(receiverOpenid);
		templateMessage.setTemplateId(tplMsg.getTemplateId());
		templateMessage.setUrl(url);
		
		String firstColor = StringUtils.defaultIfBlank(color, StringUtils.defaultIfBlank(tplMsg.getFirstColor(), WxTemplateMessage.DEFAULT_COLOR));
		templateMessage.getData().add(new WxMpTemplateData("first", first, firstColor));
		
		if (StringUtils.isNotBlank(keyword1)) {
			String keyword1Color = StringUtils.defaultIfBlank(color, StringUtils.defaultIfBlank(tplMsg.getKeyword1Color(), WxTemplateMessage.DEFAULT_COLOR));
			templateMessage.getData().add(new WxMpTemplateData("keyword1", keyword1, keyword1Color));
		}
		if (StringUtils.isNotBlank(keyword2)) {
			String keyword2Color = StringUtils.defaultIfBlank(color, StringUtils.defaultIfBlank(tplMsg.getKeyword2Color(), WxTemplateMessage.DEFAULT_COLOR));
			templateMessage.getData().add(new WxMpTemplateData("keyword2", keyword2, keyword2Color));
		}
		if (StringUtils.isNotBlank(keyword3)) {
			String keyword3Color = StringUtils.defaultIfBlank(color, StringUtils.defaultIfBlank(tplMsg.getKeyword3Color(), WxTemplateMessage.DEFAULT_COLOR));
			templateMessage.getData().add(new WxMpTemplateData("keyword3", keyword3, keyword3Color));
		}
		if (StringUtils.isNotBlank(keyword4)) {
			String keyword4Color = StringUtils.defaultIfBlank(color, StringUtils.defaultIfBlank(tplMsg.getKeyword4Color(), WxTemplateMessage.DEFAULT_COLOR));
			templateMessage.getData().add(new WxMpTemplateData("keyword4", keyword4, keyword4Color));
		}
		if (StringUtils.isNotBlank(keyword5)) {
			String keyword5Color = StringUtils.defaultIfBlank(color, StringUtils.defaultIfBlank(tplMsg.getKeyword5Color(), WxTemplateMessage.DEFAULT_COLOR));
			templateMessage.getData().add(new WxMpTemplateData("keyword5", keyword5, keyword5Color));
		}
		String remarkColor = StringUtils.defaultIfBlank(color, StringUtils.defaultIfBlank(tplMsg.getRemarkColor(), WxTemplateMessage.DEFAULT_COLOR));
		templateMessage.getData().add(new WxMpTemplateData("remark", remark, remarkColor));

		return sendWxMpTemplateMessage(account, templateMessage);
	}

	/*private static WxTemplateMessageService getService() {
		WebApplicationContext applicationContext = ContextLoader.getCurrentWebApplicationContext();
		Map<String, WxTemplateMessageService> beanMaps = applicationContext
				.getBeansOfType(WxTemplateMessageService.class);

		return beanMaps.values().iterator().next();
	}*/

}
